/*
 * Decompiled with CFR 0.152.
 */
package com.sangcomz.fishbun.ui.detail.model;

import android.net.Uri;
import com.sangcomz.fishbun.adapter.image.ImageAdapter;
import com.sangcomz.fishbun.datasource.FishBunDataSource;
import com.sangcomz.fishbun.ui.detail.model.DetailImageRepository;
import com.sangcomz.fishbun.ui.detail.model.DetailImageViewData;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0013\u001a\u00020\fH\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0006H\u0016J\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/sangcomz/fishbun/ui/detail/model/DetailImageRepositoryImpl;", "Lcom/sangcomz/fishbun/ui/detail/model/DetailImageRepository;", "fishBunDataSource", "Lcom/sangcomz/fishbun/datasource/FishBunDataSource;", "(Lcom/sangcomz/fishbun/datasource/FishBunDataSource;)V", "checkForFinish", "", "getDetailPickerViewData", "Lcom/sangcomz/fishbun/ui/detail/model/DetailImageViewData;", "getImageAdapter", "Lcom/sangcomz/fishbun/adapter/image/ImageAdapter;", "getImageIndex", "", "imageUri", "Landroid/net/Uri;", "getMaxCount", "getMessageLimitReached", "", "getPickerImage", "index", "getPickerImages", "", "isFullSelected", "isSelected", "selectImage", "", "unselectImage", "fishbun_release"})
public final class DetailImageRepositoryImpl
implements DetailImageRepository {
    @NotNull
    private final FishBunDataSource fishBunDataSource;

    public DetailImageRepositoryImpl(@NotNull FishBunDataSource fishBunDataSource) {
        Intrinsics.checkNotNullParameter((Object)fishBunDataSource, (String)"fishBunDataSource");
        this.fishBunDataSource = fishBunDataSource;
    }

    @Override
    @Nullable
    public Uri getPickerImage(int index) {
        return (Uri)CollectionsKt.getOrNull(this.fishBunDataSource.getPickerImages(), (int)index);
    }

    @Override
    @NotNull
    public List<Uri> getPickerImages() {
        return this.fishBunDataSource.getPickerImages();
    }

    @Override
    public boolean isSelected(@NotNull Uri imageUri) {
        Intrinsics.checkNotNullParameter((Object)imageUri, (String)"imageUri");
        return this.fishBunDataSource.getSelectedImageList().contains(imageUri);
    }

    @Override
    public int getImageIndex(@NotNull Uri imageUri) {
        Intrinsics.checkNotNullParameter((Object)imageUri, (String)"imageUri");
        return this.fishBunDataSource.getSelectedImageList().indexOf(imageUri);
    }

    @Override
    public void selectImage(@NotNull Uri imageUri) {
        Intrinsics.checkNotNullParameter((Object)imageUri, (String)"imageUri");
        this.fishBunDataSource.selectImage(imageUri);
    }

    @Override
    public void unselectImage(@NotNull Uri imageUri) {
        Intrinsics.checkNotNullParameter((Object)imageUri, (String)"imageUri");
        this.fishBunDataSource.unselectImage(imageUri);
    }

    @Override
    @NotNull
    public ImageAdapter getImageAdapter() {
        return this.fishBunDataSource.getImageAdapter();
    }

    @Override
    public boolean isFullSelected() {
        return this.fishBunDataSource.getSelectedImageList().size() == this.fishBunDataSource.getMaxCount();
    }

    @Override
    public boolean checkForFinish() {
        return this.fishBunDataSource.getIsAutomaticClose() && this.isFullSelected();
    }

    @Override
    @NotNull
    public String getMessageLimitReached() {
        return this.fishBunDataSource.getMessageLimitReached();
    }

    @Override
    public int getMaxCount() {
        return this.fishBunDataSource.getMaxCount();
    }

    @Override
    @NotNull
    public DetailImageViewData getDetailPickerViewData() {
        return this.fishBunDataSource.getDetailViewData();
    }
}

