/*
 * Decompiled with CFR 0.152.
 */
package com.sangcomz.fishbun.ui.detail.mvp;

import android.net.Uri;
import com.sangcomz.fishbun.ui.detail.DetailImageContract;
import com.sangcomz.fishbun.ui.detail.model.DetailImageRepository;
import com.sangcomz.fishbun.ui.detail.model.DetailImageViewData;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\bH\u0002J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\nH\u0016J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u0012\u001a\u00020\bH\u0002J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/sangcomz/fishbun/ui/detail/mvp/DetailImagePresenter;", "Lcom/sangcomz/fishbun/ui/detail/DetailImageContract$Presenter;", "detailView", "Lcom/sangcomz/fishbun/ui/detail/DetailImageContract$View;", "detailImageRepository", "Lcom/sangcomz/fishbun/ui/detail/model/DetailImageRepository;", "(Lcom/sangcomz/fishbun/ui/detail/DetailImageContract$View;Lcom/sangcomz/fishbun/ui/detail/model/DetailImageRepository;)V", "changeButtonStatus", "", "position", "", "changeButtonStatusInternal", "imageUri", "Landroid/net/Uri;", "getDesignViewData", "handleOnCreate", "initPosition", "initPagerPosition", "initViewPagerAdapter", "onCountClick", "fishbun_release"})
public final class DetailImagePresenter
implements DetailImageContract.Presenter {
    @NotNull
    private final DetailImageContract.View detailView;
    @NotNull
    private final DetailImageRepository detailImageRepository;

    public DetailImagePresenter(@NotNull DetailImageContract.View detailView, @NotNull DetailImageRepository detailImageRepository) {
        Intrinsics.checkNotNullParameter((Object)detailView, (String)"detailView");
        Intrinsics.checkNotNullParameter((Object)detailImageRepository, (String)"detailImageRepository");
        this.detailView = detailView;
        this.detailImageRepository = detailImageRepository;
    }

    @Override
    public void changeButtonStatus(int position) {
        Uri uri = this.detailImageRepository.getPickerImage(position);
        if (uri != null) {
            Uri uri2 = uri;
            boolean bl = false;
            boolean bl2 = false;
            Uri it = uri2;
            boolean bl3 = false;
            this.changeButtonStatusInternal(it);
        }
    }

    @Override
    public void handleOnCreate(int initPosition) {
        this.getDesignViewData();
        this.initViewPagerAdapter();
        this.initPagerPosition(initPosition);
    }

    @Override
    public void onCountClick(int position) {
        Uri uri = this.detailImageRepository.getPickerImage(position);
        if (uri == null) {
            return;
        }
        Uri imageUri = uri;
        boolean isSelected = this.detailImageRepository.isSelected(imageUri);
        if (isSelected) {
            this.detailImageRepository.unselectImage(imageUri);
        } else if (this.detailImageRepository.isFullSelected()) {
            this.detailView.showSnackbar(this.detailImageRepository.getMessageLimitReached());
        } else {
            this.detailImageRepository.selectImage(imageUri);
            if (this.detailImageRepository.checkForFinish()) {
                this.detailView.finishActivity();
            }
        }
        this.changeButtonStatusInternal(imageUri);
    }

    private final void getDesignViewData() {
        DetailImageViewData detailImageViewData = this.detailImageRepository.getDetailPickerViewData();
        DetailImageContract.View view = this.detailView;
        boolean bl = false;
        boolean bl2 = false;
        DetailImageContract.View $this$getDesignViewData_u24lambda_u2d1 = view;
        boolean bl3 = false;
        $this$getDesignViewData_u24lambda_u2d1.setToolBar(detailImageViewData);
        $this$getDesignViewData_u24lambda_u2d1.setCountButton(detailImageViewData);
        $this$getDesignViewData_u24lambda_u2d1.setBackButton();
    }

    private final void initPagerPosition(int position) {
        List<Uri> pickerImages = this.detailImageRepository.getPickerImages();
        Collection collection = pickerImages;
        boolean bl = false;
        if (!collection.isEmpty()) {
            this.changeButtonStatus(position);
            this.detailView.showImages(position, pickerImages);
        } else {
            this.detailView.finishAndShowErrorToast();
        }
    }

    private final void initViewPagerAdapter() {
        this.detailView.initViewPagerAdapter(this.detailImageRepository.getImageAdapter());
    }

    private final void changeButtonStatusInternal(Uri imageUri) {
        int imageIndex = this.detailImageRepository.getImageIndex(imageUri);
        if (imageIndex == -1) {
            this.detailView.unselectImage();
        } else if (this.detailImageRepository.getMaxCount() == 1) {
            this.detailView.updateRadioButtonWithDrawable();
        } else {
            this.detailView.updateRadioButtonWithText(String.valueOf(imageIndex + 1));
        }
    }
}

