/*
 * Decompiled with CFR 0.152.
 */
package com.sangcomz.fishbun.ui.picker;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.widget.Toolbar;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.snackbar.Snackbar;
import com.sangcomz.fishbun.BaseActivity;
import com.sangcomz.fishbun.Fishton;
import com.sangcomz.fishbun.R;
import com.sangcomz.fishbun.adapter.image.ImageAdapter;
import com.sangcomz.fishbun.datasource.CameraDataSourceImpl;
import com.sangcomz.fishbun.datasource.FishBunDataSource;
import com.sangcomz.fishbun.datasource.FishBunDataSourceImpl;
import com.sangcomz.fishbun.datasource.ImageDataSource;
import com.sangcomz.fishbun.datasource.ImageDataSourceImpl;
import com.sangcomz.fishbun.datasource.PickerIntentDataSourceImpl;
import com.sangcomz.fishbun.permission.PermissionCheck;
import com.sangcomz.fishbun.ui.detail.ui.DetailImageActivity;
import com.sangcomz.fishbun.ui.picker.PickerAdapter;
import com.sangcomz.fishbun.ui.picker.PickerContract;
import com.sangcomz.fishbun.ui.picker.PickerPresenter;
import com.sangcomz.fishbun.ui.picker.listener.OnPickerActionListener;
import com.sangcomz.fishbun.ui.picker.model.PickerListItem;
import com.sangcomz.fishbun.ui.picker.model.PickerMenuViewData;
import com.sangcomz.fishbun.ui.picker.model.PickerRepositoryImpl;
import com.sangcomz.fishbun.ui.picker.model.PickerViewData;
import com.sangcomz.fishbun.util.CameraUtil;
import com.sangcomz.fishbun.util.MainUiHandler;
import com.sangcomz.fishbun.util.SingleMediaScanner;
import com.sangcomz.fishbun.util.UiUtil;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\u0018\u0000 Y2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001YB\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0016H\u0002J\b\u0010\u0018\u001a\u00020\u0012H\u0016J\u0016\u0010\u0019\u001a\u00020\u00122\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0016J\u0010\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010!\u001a\u00020\u0012H\u0002J\"\u0010\"\u001a\u00020\u00122\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\b\u0010&\u001a\u0004\u0018\u00010'H\u0014J\b\u0010(\u001a\u00020\u0012H\u0016J\u0018\u0010)\u001a\u00020\u00122\u0006\u0010*\u001a\u00020$2\u0006\u0010+\u001a\u00020\u0014H\u0016J\u0010\u0010,\u001a\u00020\u00122\u0006\u0010*\u001a\u00020$H\u0016J\u0010\u0010-\u001a\u00020\u00122\u0006\u0010*\u001a\u00020$H\u0016J\u0012\u0010.\u001a\u00020\u00122\b\u0010/\u001a\u0004\u0018\u000100H\u0014J\u0010\u00101\u001a\u00020\u00162\u0006\u00102\u001a\u000203H\u0016J\b\u00104\u001a\u00020\u0012H\u0016J\u0010\u00105\u001a\u00020\u00162\u0006\u00106\u001a\u000207H\u0016J+\u00108\u001a\u00020\u00122\u0006\u0010#\u001a\u00020$2\f\u00109\u001a\b\u0012\u0004\u0012\u00020;0:2\u0006\u0010<\u001a\u00020=H\u0016\u00a2\u0006\u0002\u0010>J\u0010\u0010?\u001a\u00020\u00122\u0006\u0010@\u001a\u000200H\u0014J\u0010\u0010A\u001a\u00020\u00122\u0006\u0010@\u001a\u000200H\u0014J\b\u0010B\u001a\u00020\u0012H\u0016J&\u0010C\u001a\u00020\u00122\f\u0010D\u001a\b\u0012\u0004\u0012\u00020E0\u001b2\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020\u0016H\u0002J \u0010I\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010J\u001a\u00020$2\u0006\u0010K\u001a\u00020;H\u0016J\u0010\u0010L\u001a\u00020\u00122\u0006\u0010*\u001a\u00020$H\u0016J&\u0010M\u001a\u00020\u00122\f\u0010N\u001a\b\u0012\u0004\u0012\u00020E0\u001b2\u0006\u0010\u0005\u001a\u00020G2\u0006\u0010H\u001a\u00020\u0016H\u0016J\u0010\u0010O\u001a\u00020\u00122\u0006\u0010P\u001a\u00020;H\u0016J\u0010\u0010Q\u001a\u00020\u00122\u0006\u0010R\u001a\u00020$H\u0016J\u0010\u0010S\u001a\u00020\u00122\u0006\u0010T\u001a\u00020;H\u0016J\u001e\u0010U\u001a\u00020\u00122\u0006\u0010*\u001a\u00020$2\f\u0010V\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0016J\b\u0010W\u001a\u00020\u0012H\u0016J\u0010\u0010W\u001a\u00020\u00122\u0006\u0010X\u001a\u00020;H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006Z"}, d2={"Lcom/sangcomz/fishbun/ui/picker/PickerActivity;", "Lcom/sangcomz/fishbun/BaseActivity;", "Lcom/sangcomz/fishbun/ui/picker/PickerContract$View;", "Lcom/sangcomz/fishbun/ui/picker/listener/OnPickerActionListener;", "()V", "adapter", "Lcom/sangcomz/fishbun/ui/picker/PickerAdapter;", "layoutManager", "Landroidx/recyclerview/widget/GridLayoutManager;", "pickerPresenter", "Lcom/sangcomz/fishbun/ui/picker/PickerContract$Presenter;", "getPickerPresenter", "()Lcom/sangcomz/fishbun/ui/picker/PickerContract$Presenter;", "pickerPresenter$delegate", "Lkotlin/Lazy;", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "addImage", "", "pickerListImage", "Lcom/sangcomz/fishbun/ui/picker/model/PickerListItem$Image;", "checkCameraPermission", "", "checkPermission", "finishActivity", "finishActivityWithResult", "selectedImages", "", "Landroid/net/Uri;", "initRecyclerView", "pickerViewData", "Lcom/sangcomz/fishbun/ui/picker/model/PickerViewData;", "initToolBar", "initView", "onActivityResult", "requestCode", "", "resultCode", "data", "Landroid/content/Intent;", "onBackPressed", "onCheckStateChange", "position", "image", "onClickImage", "onClickThumbCount", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onCreateOptionsMenu", "menu", "Landroid/view/Menu;", "onDeselect", "onOptionsItemSelected", "item", "Landroid/view/MenuItem;", "onRequestPermissionsResult", "permissions", "", "", "grantResults", "", "(I[Ljava/lang/String;[I)V", "onRestoreInstanceState", "outState", "onSaveInstanceState", "onSuccessTakePicture", "setImageList", "pickerList", "Lcom/sangcomz/fishbun/ui/picker/model/PickerListItem;", "imageAdapter", "Lcom/sangcomz/fishbun/adapter/image/ImageAdapter;", "hasCameraInPickerPage", "setToolbarTitle", "selectedCount", "albumName", "showDetailView", "showImageList", "imageList", "showLimitReachedMessage", "messageLimitReached", "showMinimumImageMessage", "currentSelectedCount", "showNothingSelectedMessage", "messageNotingSelected", "takeANewPictureWithFinish", "addedImageList", "takePicture", "saveDir", "Companion", "fishbun_release"})
public final class PickerActivity
extends BaseActivity
implements PickerContract.View,
OnPickerActionListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy pickerPresenter$delegate = LazyKt.lazy((Function0)((Function0)new Function0<PickerPresenter>(this){
        final /* synthetic */ PickerActivity this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final PickerPresenter invoke() {
            PickerContract.View view = this.this$0;
            ContentResolver contentResolver = this.this$0.getContentResolver();
            Intrinsics.checkNotNullExpressionValue((Object)contentResolver, (String)"this.contentResolver");
            ImageDataSource imageDataSource = new ImageDataSourceImpl(contentResolver);
            FishBunDataSource fishBunDataSource = new FishBunDataSourceImpl(Fishton.INSTANCE);
            contentResolver = this.this$0.getIntent();
            Intrinsics.checkNotNullExpressionValue((Object)contentResolver, (String)"intent");
            return new PickerPresenter(view, new PickerRepositoryImpl(imageDataSource, fishBunDataSource, new PickerIntentDataSourceImpl((Intent)contentResolver), new CameraDataSourceImpl((Context)this.this$0)), new MainUiHandler());
        }
    }));
    @Nullable
    private RecyclerView recyclerView;
    @Nullable
    private PickerAdapter adapter;
    @Nullable
    private GridLayoutManager layoutManager;
    @NotNull
    private static final String TAG = "PickerActivity";

    private final PickerContract.Presenter getPickerPresenter() {
        Lazy lazy = this.pickerPresenter$delegate;
        boolean bl = false;
        return (PickerContract.Presenter)lazy.getValue();
    }

    protected void onSaveInstanceState(@NotNull Bundle outState) {
        Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
        try {
            outState.putString("instance_saved_image", this.getCameraUtil().getSavedPath());
            outState.putParcelableArrayList("instance_new_images", new ArrayList(this.getPickerPresenter().getAddedImagePathList()));
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)e.toString());
        }
        super.onSaveInstanceState(outState);
    }

    protected void onRestoreInstanceState(@NotNull Bundle outState) {
        Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
        super.onRestoreInstanceState(outState);
        try {
            ArrayList addedImagePathList = outState.getParcelableArrayList("instance_new_images");
            String savedImage = outState.getString("instance_saved_image");
            if (addedImagePathList != null) {
                this.getPickerPresenter().addAllAddedPath(addedImagePathList);
            }
            if (savedImage != null) {
                this.getCameraUtil().setSavedPath(savedImage);
            }
            this.getPickerPresenter().getPickerListItem();
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)e.toString());
        }
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_photo_picker);
        this.initView();
        if (this.checkPermission()) {
            this.getPickerPresenter().getPickerListItem();
        }
    }

    public void onBackPressed() {
        this.getPickerPresenter().transImageFinish();
    }

    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        int n = requestCode;
        switch (n) {
            case 128: {
                if (resultCode == -1) {
                    this.getPickerPresenter().onSuccessTakePicture();
                    break;
                }
                String string2 = this.getCameraUtil().getSavedPath();
                if (string2 == null) break;
                String string3 = string2;
                boolean bl = false;
                boolean bl2 = false;
                String it = string3;
                boolean bl3 = false;
                new File(it).delete();
                break;
            }
            case 130: {
                if (resultCode != -1) break;
                this.getPickerPresenter().onDetailImageActivityResult();
            }
        }
    }

    @Override
    public void onSuccessTakePicture() {
        String string2 = this.getCameraUtil().getSavedPath();
        if (string2 == null) {
            return;
        }
        String savedPath = string2;
        File savedFile = new File(savedPath);
        if (Build.VERSION.SDK_INT >= 29) {
            CameraUtil cameraUtil2 = this.getCameraUtil();
            ContentResolver contentResolver = this.getContentResolver();
            Intrinsics.checkNotNullExpressionValue((Object)contentResolver, (String)"contentResolver");
            cameraUtil2.saveImageForAndroidQOrHigher(contentResolver, savedFile);
        }
        new SingleMediaScanner((Context)this, savedFile, (Function0<Unit>)((Function0)new Function0<Unit>(this, savedFile){
            final /* synthetic */ PickerActivity this$0;
            final /* synthetic */ File $savedFile;
            {
                this.this$0 = $receiver;
                this.$savedFile = $savedFile;
                super(0);
            }

            public final void invoke() {
                PickerContract.Presenter presenter = PickerActivity.access$getPickerPresenter(this.this$0);
                Uri uri = Uri.fromFile((File)this.$savedFile);
                Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"fromFile(savedFile)");
                presenter.successTakePicture(uri);
            }
        }));
    }

    public void onRequestPermissionsResult(int requestCode, @NotNull String[] permissions, @NotNull int[] grantResults) {
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        Intrinsics.checkNotNullParameter((Object)grantResults, (String)"grantResults");
        int n = requestCode;
        switch (n) {
            case 28: {
                int[] nArray = grantResults;
                boolean bl = false;
                int[] nArray2 = nArray;
                boolean bl2 = false;
                if (!(!(nArray2.length == 0))) break;
                if (grantResults[0] == 0) {
                    this.getPickerPresenter().getPickerListItem();
                    break;
                }
                new PermissionCheck((Context)this).showPermissionDialog();
                this.finish();
                break;
            }
            case 29: {
                int[] nArray = grantResults;
                boolean bl = false;
                int[] nArray3 = nArray;
                boolean bl3 = false;
                if (!(!(nArray3.length == 0))) break;
                if (grantResults[0] == 0) {
                    this.getPickerPresenter().takePicture();
                    break;
                }
                new PermissionCheck((Context)this).showPermissionDialog();
            }
        }
    }

    public boolean onCreateOptionsMenu(@NotNull Menu menu2) {
        Intrinsics.checkNotNullParameter((Object)menu2, (String)"menu");
        this.getMenuInflater().inflate(R.menu.menu_photo_album, menu2);
        MenuItem menuDoneItem = menu2.findItem(R.id.action_done);
        MenuItem menuAllDoneItem = menu2.findItem(R.id.action_all_done);
        this.getPickerPresenter().getPickerMenuViewData((Function1<? super PickerMenuViewData, Unit>)((Function1)new Function1<PickerMenuViewData, Unit>(menuDoneItem, menuAllDoneItem){
            final /* synthetic */ MenuItem $menuDoneItem;
            final /* synthetic */ MenuItem $menuAllDoneItem;
            {
                this.$menuDoneItem = $menuDoneItem;
                this.$menuAllDoneItem = $menuAllDoneItem;
                super(1);
            }

            public final void invoke(@NotNull PickerMenuViewData it) {
                SpannableString spanString;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (it.getDrawableDoneButton() != null) {
                    this.$menuDoneItem.setIcon(it.getDrawableDoneButton());
                } else if (it.getStrDoneMenu() != null) {
                    if (it.getColorTextMenu() != Integer.MAX_VALUE) {
                        spanString = new SpannableString((CharSequence)it.getStrDoneMenu());
                        spanString.setSpan((Object)new ForegroundColorSpan(it.getColorTextMenu()), 0, spanString.length(), 0);
                        this.$menuDoneItem.setTitle((CharSequence)spanString);
                    } else {
                        this.$menuDoneItem.setTitle((CharSequence)it.getStrDoneMenu());
                    }
                    this.$menuDoneItem.setIcon(null);
                }
                if (it.isUseAllDoneButton()) {
                    this.$menuAllDoneItem.setVisible(true);
                    if (it.getDrawableAllDoneButton() != null) {
                        this.$menuAllDoneItem.setIcon(it.getDrawableAllDoneButton());
                    } else if (it.getStrAllDoneMenu() != null) {
                        if (it.getColorTextMenu() != Integer.MAX_VALUE) {
                            spanString = new SpannableString((CharSequence)it.getStrAllDoneMenu());
                            spanString.setSpan((Object)new ForegroundColorSpan(it.getColorTextMenu()), 0, spanString.length(), 0);
                            this.$menuAllDoneItem.setTitle((CharSequence)spanString);
                        } else {
                            this.$menuAllDoneItem.setTitle((CharSequence)it.getStrAllDoneMenu());
                        }
                        this.$menuAllDoneItem.setIcon(null);
                    }
                } else {
                    this.$menuAllDoneItem.setVisible(false);
                }
            }
        }));
        return true;
    }

    public boolean onOptionsItemSelected(@NotNull MenuItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        int n = item.getItemId();
        if (n == R.id.action_done) {
            this.getPickerPresenter().onClickMenuDone();
        } else if (n == R.id.action_all_done) {
            this.getPickerPresenter().onClickMenuAllDone();
        } else if (n == 16908332) {
            this.getPickerPresenter().transImageFinish();
        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    public void setToolbarTitle(@NotNull PickerViewData pickerViewData, int selectedCount, @NotNull String albumName) {
        Intrinsics.checkNotNullParameter((Object)pickerViewData, (String)"pickerViewData");
        Intrinsics.checkNotNullParameter((Object)albumName, (String)"albumName");
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            CharSequence charSequence;
            ActionBar actionBar2 = actionBar;
            boolean bl = false;
            boolean bl2 = false;
            ActionBar $this$setToolbarTitle_u24lambda_u2d1 = actionBar2;
            boolean bl3 = false;
            if (pickerViewData.getMaxCount() == 1 || !pickerViewData.isShowCount()) {
                charSequence = albumName;
            } else {
                Object[] objectArray = new Object[]{albumName, selectedCount, pickerViewData.getMaxCount()};
                charSequence = this.getString(R.string.title_toolbar, objectArray);
            }
            $this$setToolbarTitle_u24lambda_u2d1.setTitle(charSequence);
        }
    }

    private final void initView() {
        this.getPickerPresenter().getDesignViewData();
    }

    @Override
    public void initToolBar(@NotNull PickerViewData pickerViewData) {
        ActionBar bar;
        Intrinsics.checkNotNullParameter((Object)pickerViewData, (String)"pickerViewData");
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.toolbar_picker_bar);
        this.setSupportActionBar(toolbar);
        toolbar.setBackgroundColor(pickerViewData.getColorActionBar());
        toolbar.setTitleTextColor(pickerViewData.getColorActionBarTitle());
        if (Build.VERSION.SDK_INT >= 21) {
            UiUtil.setStatusBarColor((Activity)this, pickerViewData.getColorStatusBar());
        }
        if ((bar = this.getSupportActionBar()) != null) {
            ActionBar actionBar;
            bar.setDisplayHomeAsUpEnabled(true);
            if (pickerViewData.getDrawableHomeAsUpIndicator() != null && (actionBar = this.getSupportActionBar()) != null) {
                actionBar.setHomeAsUpIndicator(pickerViewData.getDrawableHomeAsUpIndicator());
            }
        }
        if (pickerViewData.isStatusBarLight() && Build.VERSION.SDK_INT >= 23) {
            toolbar.setSystemUiVisibility(8192);
        }
    }

    @Override
    public void initRecyclerView(@NotNull PickerViewData pickerViewData) {
        Intrinsics.checkNotNullParameter((Object)pickerViewData, (String)"pickerViewData");
        this.recyclerView = (RecyclerView)this.findViewById(R.id.recycler_picker_list);
        this.layoutManager = new GridLayoutManager((Context)this, pickerViewData.getPhotoSpanCount(), 1, false);
        RecyclerView recyclerView = this.recyclerView;
        if (recyclerView != null) {
            recyclerView.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        }
    }

    @Override
    public void takeANewPictureWithFinish(int position, @NotNull List<? extends Uri> addedImageList) {
        Intrinsics.checkNotNullParameter(addedImageList, (String)"addedImageList");
        this.setResult(29);
        this.finish();
    }

    @Override
    public void addImage(@NotNull PickerListItem.Image pickerListImage) {
        Intrinsics.checkNotNullParameter((Object)pickerListImage, (String)"pickerListImage");
        PickerAdapter pickerAdapter = this.adapter;
        if (pickerAdapter != null) {
            pickerAdapter.addImage(pickerListImage);
        }
    }

    @Override
    public void takePicture(@NotNull String saveDir) {
        Intrinsics.checkNotNullParameter((Object)saveDir, (String)"saveDir");
        this.getCameraUtil().takePicture((Activity)this, saveDir, 128);
    }

    @Override
    public void showImageList(@NotNull List<? extends PickerListItem> imageList, @NotNull ImageAdapter adapter, boolean hasCameraInPickerPage) {
        Intrinsics.checkNotNullParameter(imageList, (String)"imageList");
        Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
        this.setImageList(imageList, adapter, hasCameraInPickerPage);
    }

    @Override
    public void takePicture() {
        if (this.checkCameraPermission()) {
            this.getPickerPresenter().takePicture();
        }
    }

    @Override
    public void onDeselect() {
        this.getPickerPresenter().getPickerListItem();
    }

    @Override
    public void onClickImage(int position) {
        this.getPickerPresenter().onClickImage(position);
    }

    @Override
    public void onClickThumbCount(int position) {
        this.getPickerPresenter().onClickThumbCount(position);
    }

    @Override
    public void onCheckStateChange(int position, @NotNull PickerListItem.Image image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        PickerAdapter pickerAdapter = this.adapter;
        if (pickerAdapter != null) {
            pickerAdapter.updatePickerListItem(position, image);
        }
    }

    @Override
    public void showDetailView(int position) {
        this.startActivityForResult(DetailImageActivity.Companion.getDetailImageActivity((Context)this, position), 130);
    }

    @Override
    public void showLimitReachedMessage(@NotNull String messageLimitReached) {
        Intrinsics.checkNotNullParameter((Object)messageLimitReached, (String)"messageLimitReached");
        RecyclerView recyclerView = this.recyclerView;
        if (recyclerView != null) {
            RecyclerView recyclerView2 = recyclerView;
            boolean bl = false;
            boolean bl2 = false;
            RecyclerView it = recyclerView2;
            boolean bl3 = false;
            it.post(() -> PickerActivity.showLimitReachedMessage$lambda-3$lambda-2(it, messageLimitReached));
        }
    }

    @Override
    public void showMinimumImageMessage(int currentSelectedCount) {
        RecyclerView recyclerView = this.recyclerView;
        if (recyclerView != null) {
            RecyclerView recyclerView2 = recyclerView;
            boolean bl = false;
            boolean bl2 = false;
            RecyclerView it = recyclerView2;
            boolean bl3 = false;
            it.post(() -> PickerActivity.showMinimumImageMessage$lambda-5$lambda-4(it, this, currentSelectedCount));
        }
    }

    @Override
    public void showNothingSelectedMessage(@NotNull String messageNotingSelected) {
        Intrinsics.checkNotNullParameter((Object)messageNotingSelected, (String)"messageNotingSelected");
        RecyclerView recyclerView = this.recyclerView;
        if (recyclerView != null) {
            RecyclerView recyclerView2 = recyclerView;
            boolean bl = false;
            boolean bl2 = false;
            RecyclerView it = recyclerView2;
            boolean bl3 = false;
            it.post(() -> PickerActivity.showNothingSelectedMessage$lambda-7$lambda-6(it, messageNotingSelected));
        }
    }

    private final boolean checkPermission() {
        if (Build.VERSION.SDK_INT >= 23) {
            return this.getPermissionCheck().checkStoragePermission(28);
        }
        return true;
    }

    private final boolean checkCameraPermission() {
        if (Build.VERSION.SDK_INT >= 23) {
            return this.getPermissionCheck().checkCameraPermission(29);
        }
        return true;
    }

    @Override
    public void finishActivity() {
        Intent i = new Intent();
        this.setResult(-1, i);
        this.finish();
    }

    @Override
    public void finishActivityWithResult(@NotNull List<? extends Uri> selectedImages) {
        Intrinsics.checkNotNullParameter(selectedImages, (String)"selectedImages");
        Intent i = new Intent();
        this.setResult(-1, i);
        i.putParcelableArrayListExtra("intent_path", new ArrayList(selectedImages));
        this.finish();
    }

    private final void setImageList(List<? extends PickerListItem> pickerList, ImageAdapter imageAdapter, boolean hasCameraInPickerPage) {
        PickerAdapter pickerAdapter;
        if (this.adapter == null) {
            this.adapter = new PickerAdapter(imageAdapter, this, hasCameraInPickerPage);
            pickerAdapter = this.recyclerView;
            if (pickerAdapter != null) {
                pickerAdapter.setAdapter(this.adapter);
            }
        }
        if ((pickerAdapter = this.adapter) != null) {
            pickerAdapter.setPickerList(pickerList);
        }
    }

    private static final void showLimitReachedMessage$lambda-3$lambda-2(RecyclerView $it, String $messageLimitReached) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        Intrinsics.checkNotNullParameter((Object)$messageLimitReached, (String)"$messageLimitReached");
        Snackbar.make((View)((View)$it), (CharSequence)$messageLimitReached, (int)-1).show();
    }

    private static final void showMinimumImageMessage$lambda-5$lambda-4(RecyclerView $it, PickerActivity this$0, int $currentSelectedCount) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object[] objectArray = new Object[]{$currentSelectedCount};
        Snackbar.make((View)((View)$it), (CharSequence)this$0.getString(R.string.msg_minimum_image, objectArray), (int)-1).show();
    }

    private static final void showNothingSelectedMessage$lambda-7$lambda-6(RecyclerView $it, String $messageNotingSelected) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        Intrinsics.checkNotNullParameter((Object)$messageNotingSelected, (String)"$messageNotingSelected");
        Snackbar.make((View)((View)$it), (CharSequence)$messageNotingSelected, (int)-1).show();
    }

    public static final /* synthetic */ PickerContract.Presenter access$getPickerPresenter(PickerActivity $this) {
        return $this.getPickerPresenter();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J1\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/sangcomz/fishbun/ui/picker/PickerActivity$Companion;", "", "()V", "TAG", "", "getPickerActivityIntent", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "albumId", "", "albumName", "albumPosition", "", "(Landroid/content/Context;Ljava/lang/Long;Ljava/lang/String;I)Landroid/content/Intent;", "fishbun_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Intent getPickerActivityIntent(@Nullable Context context, @Nullable Long albumId, @Nullable String albumName, int albumPosition) {
            Intent intent = new Intent(context, PickerActivity.class);
            intent.putExtra("album_id", (Serializable)albumId);
            intent.putExtra("album_name", albumName);
            intent.putExtra("album_position", albumPosition);
            return intent;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

