/*
 * Decompiled with CFR 0.152.
 */
package com.sangcomz.fishbun.util;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.provider.MediaStore;
import androidx.core.content.FileProvider;
import java.io.Closeable;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nH\u0007J\u001e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/sangcomz/fishbun/util/CameraUtil;", "", "()V", "savedPath", "", "getSavedPath", "()Ljava/lang/String;", "setSavedPath", "(Ljava/lang/String;)V", "createImageFile", "Ljava/io/File;", "saveDir", "saveImageForAndroidQOrHigher", "", "contentResolver", "Landroid/content/ContentResolver;", "file", "takePicture", "activity", "Landroid/app/Activity;", "requestCode", "", "fishbun_release"})
public final class CameraUtil {
    @Nullable
    private String savedPath;

    @Nullable
    public final String getSavedPath() {
        return this.savedPath;
    }

    public final void setSavedPath(@Nullable String string2) {
        this.savedPath = string2;
    }

    public final void takePicture(@NotNull Activity activity, @NotNull String saveDir, int requestCode) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)saveDir, (String)"saveDir");
        Intent takePictureIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (takePictureIntent.resolveActivity(activity.getPackageManager()) != null) {
            File photoFile = null;
            try {
                photoFile = this.createImageFile(saveDir);
                this.savedPath = photoFile.getAbsolutePath();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            if (photoFile != null) {
                Uri uri;
                Uri uri2;
                if (Build.VERSION.SDK_INT >= 24) {
                    uri2 = FileProvider.getUriForFile((Context)((Context)activity), (String)Intrinsics.stringPlus((String)activity.getApplicationContext().getPackageName(), (Object)".fishbunfileprovider"), (File)photoFile);
                    Intrinsics.checkNotNullExpressionValue((Object)uri2, (String)"{\n                    FileProvider.getUriForFile(\n                        activity,\n                        activity.applicationContext.packageName + \".fishbunfileprovider\",\n                        photoFile\n                    )\n                }");
                    uri = uri2;
                } else {
                    uri2 = Uri.fromFile((File)photoFile);
                    Intrinsics.checkNotNullExpressionValue((Object)uri2, (String)"{\n                    Uri.fromFile(photoFile)\n                }");
                    uri = uri2;
                }
                Uri uri3 = uri;
                takePictureIntent.putExtra("output", (Parcelable)uri3);
                activity.startActivityForResult(takePictureIntent, requestCode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=29)
    public final void saveImageForAndroidQOrHigher(@NotNull ContentResolver contentResolver, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)contentResolver, (String)"contentResolver");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ContentValues values = new ContentValues();
        values.put("_display_name", file.getName());
        values.put("mime_type", "image/jpg");
        values.put("is_pending", Integer.valueOf(1));
        Uri uri = contentResolver.insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);
        if (uri != null) {
            Uri uri2 = uri;
            boolean bl = false;
            boolean bl2 = false;
            Uri it = uri2;
            boolean bl3 = false;
            Closeable closeable = (Closeable)contentResolver.openFileDescriptor(it, "w");
            boolean bl4 = false;
            boolean bl5 = false;
            Throwable throwable = null;
            try {
                Object object;
                ParcelFileDescriptor parcelFileDescriptor = (ParcelFileDescriptor)closeable;
                boolean bl6 = false;
                ParcelFileDescriptor parcelFileDescriptor2 = parcelFileDescriptor;
                Object object2 = object = parcelFileDescriptor2 == null ? null : parcelFileDescriptor2.getFileDescriptor();
                if (object != null) {
                    FileDescriptor fileDescriptor = object;
                    object = new FileOutputStream(fileDescriptor);
                    boolean bl7 = false;
                    boolean bl8 = false;
                    Throwable throwable2 = null;
                    try {
                        FileOutputStream fileOutputStream = (FileOutputStream)object;
                        boolean bl9 = false;
                        Object object3 = file;
                        boolean bl10 = false;
                        FileInputStream inputStream = new FileInputStream((File)object3);
                        object3 = inputStream;
                        bl10 = false;
                        boolean bl11 = false;
                        Throwable throwable3 = null;
                        try {
                            FileInputStream it2 = (FileInputStream)object3;
                            boolean bl12 = false;
                            fileOutputStream.write(ByteStreamsKt.readBytes((InputStream)it2));
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable4) {
                            throwable3 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)object3, (Throwable)throwable3);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable5) {
                        throwable2 = throwable5;
                        throw throwable5;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object, (Throwable)throwable2);
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            values.clear();
            values.put("is_pending", Integer.valueOf(0));
            contentResolver.update(it, values, null, null);
        }
    }

    private final File createImageFile(String saveDir) throws IOException {
        File dir = new File(saveDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        String imageFileName = "JPEG_" + timeStamp + '_';
        File storageDir = new File(saveDir);
        File file = File.createTempFile(imageFileName, ".jpg", storageDir);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempFile(\n            imageFileName,  /* prefix */\n            \".jpg\",  /* suffix */\n            storageDir /* directory */\n        )");
        return file;
    }
}

