create sequence gx_country_seq;
create sequence gx_state_seq;
create sequence gx_city_seq;

create table gx_country(
	oid integer not null default nextval('gx_country_seq'),
	is_active boolean not null default true,
	country_name varchar(50) not null,
	alpha3_code varchar(3) not null,
	numeric_code integer,
	primary key (oid)
);

create table gx_state(
	oid integer not null default nextval('gx_state_seq'),
	is_active boolean not null default true,
	state_name varchar(50) not null,
	state_code varchar(3),
	oid_gx_country integer not null,
	primary key (oid),
	
	foreign key (oid_gx_country) references gx_country(oid) on delete restrict on update cascade
);

create table gx_city(
	oid integer not null default nextval('gx_city_seq'),
	is_active boolean not null default true,
	city_name varchar(50) not null,
	oid_gx_country integer not null,
	oid_gx_state integer,
	primary key (oid),
	
	foreign key (oid_gx_country) references gx_country(oid) on delete restrict on update cascade,
	foreign key (oid_gx_state) references gx_state(oid) on delete restrict on update cascade
);


insert into gx_country (country_name,alpha3_code,numeric_code) values ('Afghanistan','AFG','4');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Albania','ALB','8');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Algeria','DZA','12');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('American Samoa','ASM','16');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Andorra','AND','20');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Angola','AGO','24');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Anguilla','AIA','660');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Antarctica','ATA','10');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Antigua and Barbuda','ATG','28');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Argentina','ARG','32');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Armenia','ARM','51');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Aruba','ABW','533');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Australia','AUS','36');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Austria','AUT','40');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Azerbaijan','AZE','31');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Bahamas','BHS','44');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Bahrain','BHR','48');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Bangladesh','BGD','50');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Barbados','BRB','52');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Belarus','BLR','112');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Belgium','BEL','56');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Belize','BLZ','84');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Benin','BEN','204');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Bermuda','BMU','60');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Bhutan','BTN','64');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Bolivia, Plurinational State of','BOL','68');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Bonaire, Sint Eustatius and Saba','BES','535');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Bosnia and Herzegovina','BIH','70');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Botswana','BWA','72');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Bouvet Island','BVT','74');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Brazil','BRA','76');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('British Indian Ocean Territory','IOT','86');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Brunei Darussalam','BRN','96');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Bulgaria','BGR','100');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Burkina Faso','BFA','854');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Burundi','BDI','108');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Cambodia','KHM','116');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Cameroon','CMR','120');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Canada','CAN','124');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Cape Verde','CPV','132');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Cayman Islands','CYM','136');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Central African Republic','CAF','140');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Chad','TCD','148');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Chile','CHL','152');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('China','CHN','156');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Christmas Island','CXR','162');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Cocos (Keeling) Islands','CCK','166');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Colombia','COL','170');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Comoros','COM','174');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Congo','COG','178');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Congo, the Democratic Republic of the','COD','180');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Cook Islands','COK','184');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Costa Rica','CRI','188');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Croatia','HRV','191');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Cuba','CUB','192');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Curaçao','CUW','531');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Cyprus','CYP','196');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Czech Republic','CZE','203');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Côte d''Ivoire','CIV','384');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Denmark','DNK','208');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Djibouti','DJI','262');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Dominica','DMA','212');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Dominican Republic','DOM','214');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Ecuador','ECU','218');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Egypt','EGY','818');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('El Salvador','SLV','222');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Equatorial Guinea','GNQ','226');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Eritrea','ERI','232');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Estonia','EST','233');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Ethiopia','ETH','231');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Falkland Islands (Malvinas)','FLK','238');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Faroe Islands','FRO','234');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Fiji','FJI','242');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Finland','FIN','246');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('France','FRA','250');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('French Guiana','GUF','254');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('French Polynesia','PYF','258');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('French Southern Territories','ATF','260');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Gabon','GAB','266');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Gambia','GMB','270');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Georgia','GEO','268');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Germany','DEU','276');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Ghana','GHA','288');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Gibraltar','GIB','292');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Greece','GRC','300');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Greenland','GRL','304');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Grenada','GRD','308');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Guadeloupe','GLP','312');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Guam','GUM','316');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Guatemala','GTM','320');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Guinea','GIN','324');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Guinea-Bissau','GNB','624');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Guyana','GUY','328');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Haiti','HTI','332');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Heard Island and McDonald Islands','HMD','334');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Holy See (Vatican City State)','VAT','336');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Honduras','HND','340');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Hong Kong','HKG','344');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Hungary','HUN','348');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Iceland','ISL','352');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('India','IND','356');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Indonesia','IDN','360');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Iran, Islamic Republic of','IRN','364');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Iraq','IRQ','368');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Ireland','IRL','372');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Israel','ISR','376');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Italy','ITA','380');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Jamaica','JAM','388');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Japan','JPN','392');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Jordan','JOR','400');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Kazakhstan','KAZ','398');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Kenya','KEN','404');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Kiribati','KIR','296');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Korea, Democratic People''s Republic of','PRK','408');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Korea, Republic of','KOR','410');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Kuwait','KWT','414');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Kyrgyzstan','KGZ','417');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Lao People''s Democratic Republic','LAO','418');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Latvia','LVA','428');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Lebanon','LBN','422');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Lesotho','LSO','426');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Liberia','LBR','430');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Libya','LBY','434');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Liechtenstein','LIE','438');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Lithuania','LTU','440');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Luxembourg','LUX','442');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Macao','MAC','446');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Macedonia, the former Yugoslav Republic of','MKD','807');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Madagascar','MDG','450');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Malawi','MWI','454');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Malaysia','MYS','458');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Maldives','MDV','462');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Mali','MLI','466');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Malta','MLT','470');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Marshall Islands','MHL','584');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Martinique','MTQ','474');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Mauritania','MRT','478');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Mauritius','MUS','480');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Mayotte','MYT','175');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Mexico','MEX','484');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Micronesia, Federated States of','FSM','583');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Moldova, Republic of','MDA','498');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Monaco','MCO','492');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Mongolia','MNG','496');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Montenegro','MNE','499');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Montserrat','MSR','500');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Morocco','MAR','504');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Mozambique','MOZ','508');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Myanmar','MMR','104');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Namibia','NAM','516');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Nauru','NRU','520');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Nepal','NPL','524');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Netherlands','NLD','528');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('New Caledonia','NCL','540');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('New Zealand','NZL','554');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Nicaragua','NIC','558');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Niger','NER','562');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Nigeria','NGA','566');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Niue','NIU','570');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Norfolk Island','NFK','574');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Northern Mariana Islands','MNP','580');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Norway','NOR','578');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Oman','OMN','512');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Pakistan','PAK','586');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Palau','PLW','585');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Palestinian Territory, Occupied','PSE','275');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Panama','PAN','591');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Papua New Guinea','PNG','598');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Paraguay','PRY','600');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Peru','PER','604');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Philippines','PHL','608');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Pitcairn','PCN','612');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Poland','POL','616');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Portugal','PRT','620');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Puerto Rico','PRI','630');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Qatar','QAT','634');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Republic of Kosovo','XK','991');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Romania','ROU','642');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Russian Federation','RUS','643');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Rwanda','RWA','646');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Réunion','REU','638');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Saint Helena, Ascension and Tristan da Cunha','SHN','654');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Saint Kitts and Nevis','KNA','659');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Saint Lucia','LCA','662');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Saint Pierre and Miquelon','SPM','666');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Saint Vincent and the Grenadines','VCT','670');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Samoa','WSM','882');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('San Marino','SMR','674');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Sao Tome and Principe','STP','678');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Saudi Arabia','SAU','682');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Senegal','SEN','686');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Serbia','SRB','688');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Seychelles','SYC','690');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Sierra Leone','SLE','694');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Singapore','SGP','702');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Sint Maarten (Dutch part)','SXM','534');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Slovakia','SVK','703');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Slovenia','SVN','705');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Solomon Islands','SLB','90');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Somalia','SOM','706');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('South Africa','ZAF','710');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('South Georgia and the South Sandwich Islands','SGS','239');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('South Sudan','SSD','728');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Spain','ESP','724');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Sri Lanka','LKA','144');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Sudan','SDN','729');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Suriname','SUR','740');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Svalbard and Jan Mayen','SJM','744');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Swaziland','SWZ','748');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Sweden','SWE','752');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Switzerland','CHE','756');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Syrian Arab Republic','SYR','760');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Taiwan, Province of China','TWN','158');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Tajikistan','TJK','762');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Tanzania, United Republic of','TZA','834');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Thailand','THA','764');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Togo','TGO','768');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Tokelau','TKL','772');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Tonga','TON','776');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Trinidad and Tobago','TTO','780');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Tunisia','TUN','788');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Turkey','TUR','792');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Turkmenistan','TKM','795');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Turks and Caicos Islands','TCA','796');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Tuvalu','TUV','798');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Uganda','UGA','800');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Ukraine','UKR','804');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('United Arab Emirates','ARE','784');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('United Kingdom','GBR','826');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('United States','USA','840');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('United States Minor Outlying Islands','UMI','581');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Uruguay','URY','858');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Uzbekistan','UZB','860');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Vanuatu','VUT','548');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Venezuela, Bolivarian Republic of','VEN','862');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Viet Nam','VNM','704');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Virgin Islands, British','VGB','92');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Virgin Islands, U.S.','VIR','850');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Wallis and Futuna','WLF','876');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Western Sahara','ESH','732');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Yemen','YEM','887');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Zambia','ZMB','894');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Zimbabwe','ZWE','716');
insert into gx_country (country_name,alpha3_code,numeric_code) values ('Åland Islands','ALA','248');




insert into gx_state (state_name,state_code,oid_gx_country) select 'Alberta','AB',oid from gx_country where alpha3_code  ='CAN';
insert into gx_state (state_name,state_code,oid_gx_country) select 'British Columbia','BC',oid from gx_country where alpha3_code  ='CAN';
insert into gx_state (state_name,state_code,oid_gx_country) select 'Manitoba','MB',oid from gx_country where alpha3_code  ='CAN';
insert into gx_state (state_name,state_code,oid_gx_country) select 'New Brunswick','NB',oid from gx_country where alpha3_code  ='CAN';
insert into gx_state (state_name,state_code,oid_gx_country) select 'Newfoundland and Labrador','NL',oid from gx_country where alpha3_code  ='CAN';
insert into gx_state (state_name,state_code,oid_gx_country) select 'Northwest Territories','NT',oid from gx_country where alpha3_code  ='CAN';
insert into gx_state (state_name,state_code,oid_gx_country) select 'Nova Scotia','NS',oid from gx_country where alpha3_code  ='CAN';
insert into gx_state (state_name,state_code,oid_gx_country) select 'Nunavut','NU',oid from gx_country where alpha3_code  ='CAN';
insert into gx_state (state_name,state_code,oid_gx_country) select 'Ontario','ON',oid from gx_country where alpha3_code  ='CAN';
insert into gx_state (state_name,state_code,oid_gx_country) select 'Prince Edward Island','PE',oid from gx_country where alpha3_code  ='CAN';
insert into gx_state (state_name,state_code,oid_gx_country) select 'Quebec','QC',oid from gx_country where alpha3_code  ='CAN';
insert into gx_state (state_name,state_code,oid_gx_country) select 'Saskatchewan','SK',oid from gx_country where alpha3_code  ='CAN';
insert into gx_state (state_name,state_code,oid_gx_country) select 'Yukon','YT',oid from gx_country where alpha3_code  ='CAN';



insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Acton', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Ajax', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Alexandria', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Alfred', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Alliston', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Almonte', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Amherstburg', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Amigo Beach', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Angus-Borden', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Arnprior', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Arthur', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Athens', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Atikokan', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Attawapiskat', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Aurora', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Aylmer', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Ayr', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Barrie', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Barry''s Bay', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Beamsville', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Beaverton', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Beeton', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Belleville', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Belmont', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Blenheim', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Blind River', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Bobcaygeon', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Bolton', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Bourget', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Bowmanville-Newcastle', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Bracebridge', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Bradford', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Brampton', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Brantford', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Bridgenorth-Chemong Park Area', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Brighton', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Brockville', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Brooklin', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Brussels', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Burford', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Burlington', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Caledon', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Caledon East', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Caledonia', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Cambridge', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Campbellford', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Campbellville', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Cannington', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Capreol', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Cardinal', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Carleton Place', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Carlisle', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Casselman', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Cayuga', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Chalk River', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Chapleau', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Chatham', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Chesley', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Chesterville', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Clinton', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Cobourg', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Cochrane', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Colborne', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Colchester', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Collingwood', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Concord', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Constance Bay', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Cookstown', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Cornwall', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Creemore', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Crystal Beach', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Deep River', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Delhi', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Deseronto', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Downsview', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Drayton', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Dresden', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Dryden', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Dundalk', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Dunnville', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Durham', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Dutton', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Eganville', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Elliot Lake', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Elmira', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Elmvale', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Embrun', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Englehart', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Erin', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Espanola', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Essex', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Etobicoke', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Everett', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Exeter', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Fenelon Falls', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Fergus', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Forest', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Fort Erie', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Fort Frances', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Frankford', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Gananoque', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Georgetown', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Georgina', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Geraldton', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Glencoe', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Goderich', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Golden', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Gormley', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Grand Bend', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Grand Valley', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Gravenhurst', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Guelph', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Hagersville', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Haileybury', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Hamilton', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Hanover', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Harriston', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Harrow', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Hastings', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Havelock', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Hawkesbury', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Hearst', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Hensall', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Hillsburgh', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Hornepayne', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Huntsville', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Ingersoll', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Innisfil', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Iroquois', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Iroquois Falls', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Jarvis', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Kanata', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Kapuskasing', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Kars', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Kemptville', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Kenora', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Kincardine', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Kingston', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Kirkland Lake', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Kitchener', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'L''Original', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Lakefield', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Lanark', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Leamington', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Lindsay', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Listowel', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Little Current', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Lively', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'London', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Longlac', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Lucan', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Lucknow', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Madoc', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Manitouwadge', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Maple', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Marathon', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Markdale', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Markham', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Marmora', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Mattawa', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Meaford', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Metcalfe', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Midland', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Mildmay', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Millbrook', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Milton', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Milverton', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Mississauga', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Mississauga Beach', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Mitchell', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Moose Factory', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Morrisburg', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Mount Albert', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Mount Brydges', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Mount Forest', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Munster', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Nanticoke', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Napanee', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Nepean', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'New Hamburg', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Newmarket', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Newtonville', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Nobleton', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'North Bay', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'North Gower', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'North York', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Norwich', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Norwood', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Oakville', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Omemee', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Onaping-Levack', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Ontario', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Orangeville', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Orillia', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Orono', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Osgoode', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Oshawa', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Ottawa', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Owen Sound', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Paisley', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Palmerston', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Paris', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Parkhill', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Parry Sound', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Pembroke', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Perth', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Petawawa', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Peterborough', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Petrolia', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Pickering', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Picton', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Porcupine', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Port Credit', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Port Dover', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Port Elgin', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Port Hope', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Port Perry', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Port Stanley', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Powassan', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Prescott', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Queensville', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Renfrew', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Richmond', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Richmond Hill', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Ridgetown', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Rockland', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Rockwood', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Rodney', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Saint Catharines', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Saint Catharines-Niagara', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Saint George', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Saint Jacobs', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Saint Marys', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Saint Thomas', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Sarnia', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Sault Sainte Marie', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Scarborough', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Schomberg', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Seaforth', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Shelburne', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Simcoe', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Sioux Lookout', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Smiths Falls', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Smithville', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'South River', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Southampton', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Stayner', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Stirling', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Stoney Creek', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Stoney Point', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Stouffville', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Stratford', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Strathroy', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Sturgeon Falls', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Sudbury', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Sutton', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Tavistock', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Teeswater', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Terrace Bay', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Thamesford', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Thessalon', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Thornbury', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Thornhill', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Thunder Bay', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Tilbury', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Tilsonburg', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Timmins', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Toronto', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Tory Hill', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Tottenham', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Tweed', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Uxbridge', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Valley East', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Vankleek Hill', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Vaughan', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Vineland', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Walkerton', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Wallaceburg', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Wasaga Beach', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Waterdown', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Waterford', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Waterloo', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Watford', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Wawa', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Welland', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Wellesley', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Wellington', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'West Lorne', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Wheatley', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Whitby', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Whitchurch-Stouffville', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Wiarton', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Wikwemikong', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Willowdale', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Winchester', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Windsor', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Wingham', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Woodbridge', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Woodstock', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';
insert into gx_city (city_name,oid_gx_country,oid_gx_state) select 'Wyoming', gx_state.oid_gx_country,gx_state.oid from gx_state where state_code ='ON';