/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.grpc.Call;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingCall;
import io.grpc.ForwardingCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class ClientInterceptors {
    private static final Call<Object, Object> NOOP_CALL = new Call<Object, Object>(){

        @Override
        public void start(Call.Listener<Object> responseListener, Metadata.Headers headers) {
        }

        @Override
        public void request(int numMessages) {
        }

        @Override
        public void cancel() {
        }

        @Override
        public void halfClose() {
        }

        @Override
        public void sendPayload(Object payload) {
        }

        @Override
        public boolean isReady() {
            return false;
        }
    };

    private ClientInterceptors() {
    }

    public static Channel intercept(Channel channel, ClientInterceptor ... interceptors) {
        return ClientInterceptors.intercept(channel, Arrays.asList(interceptors));
    }

    public static Channel intercept(Channel channel, List<ClientInterceptor> interceptors) {
        Preconditions.checkNotNull((Object)channel);
        if (interceptors.isEmpty()) {
            return channel;
        }
        return new InterceptorChannel(channel, interceptors);
    }

    @Deprecated
    public static class ForwardingListener<T>
    extends ForwardingCallListener.SimpleForwardingCallListener<T> {
        public ForwardingListener(Call.Listener<T> delegate) {
            super(delegate);
        }
    }

    public static abstract class CheckedForwardingCall<ReqT, RespT>
    extends io.grpc.ForwardingCall<ReqT, RespT> {
        private Call<ReqT, RespT> delegate;

        protected abstract void checkedStart(Call.Listener<RespT> var1, Metadata.Headers var2) throws Exception;

        protected CheckedForwardingCall(Call<ReqT, RespT> delegate) {
            this.delegate = delegate;
        }

        @Override
        protected final Call<ReqT, RespT> delegate() {
            return this.delegate;
        }

        @Override
        public final void start(Call.Listener<RespT> responseListener, Metadata.Headers headers) {
            try {
                this.checkedStart(responseListener, headers);
            }
            catch (Exception e) {
                this.delegate = NOOP_CALL;
                responseListener.onClose(Status.fromThrowable(e), new Metadata.Trailers());
            }
        }
    }

    @Deprecated
    public static class ForwardingCall<ReqT, RespT>
    extends ForwardingCall.SimpleForwardingCall<ReqT, RespT> {
        public ForwardingCall(Call<ReqT, RespT> delegate) {
            super(delegate);
        }
    }

    private static class ProcessInterceptorChannel
    extends Channel {
        private final Channel channel;
        private Iterator<ClientInterceptor> interceptors;

        private ProcessInterceptorChannel(Channel channel, Iterable<ClientInterceptor> interceptors) {
            this.channel = channel;
            this.interceptors = interceptors.iterator();
        }

        public <ReqT, RespT> Call<ReqT, RespT> newCall(MethodDescriptor<ReqT, RespT> method) {
            if (this.interceptors != null && this.interceptors.hasNext()) {
                return this.interceptors.next().interceptCall(method, this);
            }
            Preconditions.checkState((this.interceptors != null ? 1 : 0) != 0, (Object)"The channel has already been called. Some interceptor must have called on \"next\" twice.");
            this.interceptors = null;
            return this.channel.newCall(method);
        }
    }

    private static class InterceptorChannel
    extends Channel {
        private final Channel channel;
        private final Iterable<ClientInterceptor> interceptors;

        private InterceptorChannel(Channel channel, List<ClientInterceptor> interceptors) {
            this.channel = channel;
            this.interceptors = ImmutableList.copyOf(interceptors);
        }

        public <ReqT, RespT> Call<ReqT, RespT> newCall(MethodDescriptor<ReqT, RespT> method) {
            return new ProcessInterceptorChannel(this.channel, this.interceptors).newCall(method);
        }
    }
}

