/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import com.google.common.base.Preconditions;
import io.grpc.Marshaller;
import io.grpc.MethodType;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.Immutable;

@Immutable
public class MethodDescriptor<RequestT, ResponseT> {
    private final MethodType type;
    private final String name;
    private final Marshaller<RequestT> requestMarshaller;
    private final Marshaller<ResponseT> responseMarshaller;
    private final long timeoutMicros;

    public static <RequestT, ResponseT> MethodDescriptor<RequestT, ResponseT> create(MethodType type, String name, long timeout, TimeUnit timeoutUnit, Marshaller<RequestT> requestMarshaller, Marshaller<ResponseT> responseMarshaller) {
        return new MethodDescriptor<RequestT, ResponseT>(type, name, timeoutUnit.toMicros(timeout), requestMarshaller, responseMarshaller);
    }

    private MethodDescriptor(MethodType type, String name, long timeoutMicros, Marshaller<RequestT> requestMarshaller, Marshaller<ResponseT> responseMarshaller) {
        this.type = (MethodType)((Object)Preconditions.checkNotNull((Object)((Object)type)));
        this.name = name;
        Preconditions.checkArgument((timeoutMicros > 0L ? 1 : 0) != 0);
        this.timeoutMicros = timeoutMicros;
        this.requestMarshaller = requestMarshaller;
        this.responseMarshaller = responseMarshaller;
    }

    public MethodType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public long getTimeout() {
        return this.timeoutMicros;
    }

    public ResponseT parseResponse(InputStream input) {
        return this.responseMarshaller.parse(input);
    }

    public InputStream streamRequest(RequestT requestMessage) {
        return this.requestMarshaller.stream(requestMessage);
    }

    public MethodDescriptor<RequestT, ResponseT> withTimeout(long timeout, TimeUnit unit) {
        return new MethodDescriptor<RequestT, ResponseT>(this.type, this.name, unit.toMicros(timeout), this.requestMarshaller, this.responseMarshaller);
    }
}

