/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.grpc.Marshaller;
import io.grpc.ServerCallHandler;
import io.grpc.ServerMethodDefinition;
import java.util.HashMap;
import java.util.Map;

public final class ServerServiceDefinition {
    private final String name;
    private final ImmutableList<ServerMethodDefinition<?, ?>> methods;
    private final ImmutableMap<String, ServerMethodDefinition<?, ?>> methodLookup;

    public static Builder builder(String serviceName) {
        return new Builder(serviceName);
    }

    private ServerServiceDefinition(String name, ImmutableList<ServerMethodDefinition<?, ?>> methods, Map<String, ServerMethodDefinition<?, ?>> methodLookup) {
        this.name = name;
        this.methods = methods;
        this.methodLookup = ImmutableMap.copyOf(methodLookup);
    }

    public String getName() {
        return this.name;
    }

    public ImmutableList<ServerMethodDefinition<?, ?>> getMethods() {
        return this.methods;
    }

    public ServerMethodDefinition<?, ?> getMethod(String name) {
        return (ServerMethodDefinition)this.methodLookup.get((Object)name);
    }

    public static final class Builder {
        private final String serviceName;
        private final ImmutableList.Builder<ServerMethodDefinition<?, ?>> methods = ImmutableList.builder();
        private final Map<String, ServerMethodDefinition<?, ?>> methodLookup = new HashMap();

        private Builder(String serviceName) {
            this.serviceName = serviceName;
        }

        public <ReqT, RespT> Builder addMethod(String name, Marshaller<ReqT> requestMarshaller, Marshaller<RespT> responseMarshaller, ServerCallHandler<ReqT, RespT> handler) {
            return this.addMethod(new ServerMethodDefinition((String)Preconditions.checkNotNull((Object)name, (Object)"name must not be null"), (Marshaller)Preconditions.checkNotNull(requestMarshaller, (Object)"requestMarshaller must not be null"), (Marshaller)Preconditions.checkNotNull(responseMarshaller, (Object)"responseMarshaller must not be null"), (ServerCallHandler)Preconditions.checkNotNull(handler, (Object)"handler must not be null")));
        }

        public <ReqT, RespT> Builder addMethod(ServerMethodDefinition<ReqT, RespT> def) {
            if (this.methodLookup.containsKey(def.getName())) {
                throw new IllegalStateException("Method by same name already registered");
            }
            this.methodLookup.put(def.getName(), def);
            this.methods.add(def);
            return this;
        }

        public ServerServiceDefinition build() {
            return new ServerServiceDefinition(this.serviceName, this.methods.build(), this.methodLookup);
        }
    }
}

