/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.transport;

import com.google.common.base.Charsets;
import com.google.common.io.BaseEncoding;
import io.grpc.Metadata;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class TransportFrameUtil {
    private static final Logger logger = Logger.getLogger(TransportFrameUtil.class.getName());
    private static final byte[] binaryHeaderSuffixBytes = "-bin".getBytes(Charsets.US_ASCII);

    @Nullable
    public static String getFullMethodNameFromPath(String path) {
        if (!path.startsWith("/")) {
            return null;
        }
        return path;
    }

    public static byte[][] toHttp2Headers(Metadata headers) {
        byte[][] serializedHeaders = headers.serialize();
        ArrayList<byte[]> result = new ArrayList<byte[]>(serializedHeaders.length);
        for (int i = 0; i < serializedHeaders.length; i += 2) {
            byte[] key = serializedHeaders[i];
            byte[] value = serializedHeaders[i + 1];
            if (TransportFrameUtil.endsWith(key, binaryHeaderSuffixBytes)) {
                result.add(key);
                result.add(BaseEncoding.base64().encode(value).getBytes(Charsets.US_ASCII));
                continue;
            }
            if (TransportFrameUtil.isSpecCompliantAscii(value)) {
                result.add(key);
                result.add(value);
                continue;
            }
            String keyString = new String(key, Charsets.US_ASCII);
            logger.warning("Metadata key=" + keyString + ", value=" + Arrays.toString(value) + " contains invalid ASCII characters");
        }
        return (byte[][])result.toArray((T[])new byte[result.size()][]);
    }

    public static byte[][] toRawSerializedHeaders(byte[][] http2Headers) {
        byte[][] result = new byte[http2Headers.length][];
        for (int i = 0; i < http2Headers.length; i += 2) {
            byte[] key = http2Headers[i];
            byte[] value = http2Headers[i + 1];
            result[i] = key;
            result[i + 1] = TransportFrameUtil.endsWith(key, binaryHeaderSuffixBytes) ? BaseEncoding.base64().decode((CharSequence)new String(value, Charsets.US_ASCII)) : value;
        }
        return result;
    }

    private static boolean endsWith(byte[] subject, byte[] suffix) {
        int start = subject.length - suffix.length;
        if (start < 0) {
            return false;
        }
        for (int i = start; i < subject.length; ++i) {
            if (subject[i] == suffix[i - start]) continue;
            return false;
        }
        return true;
    }

    private static boolean isSpecCompliantAscii(byte[] subject) {
        for (byte b : subject) {
            if (b >= 32 && b <= 126) continue;
            return false;
        }
        return true;
    }

    private TransportFrameUtil() {
    }
}

