/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.Codec;
import io.grpc.Decompressor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;

public final class DecompressorRegistry {
    private static final DecompressorRegistry INSTANCE = new DecompressorRegistry();
    private final ConcurrentMap<String, DecompressorInfo> decompressors = new ConcurrentHashMap<String, DecompressorInfo>();

    public static void register(Decompressor d, boolean advertised) {
        INSTANCE.internalRegister(d, advertised);
    }

    @VisibleForTesting
    void internalRegister(Decompressor d, boolean advertised) {
        DecompressorInfo previousInfo = this.decompressors.putIfAbsent(d.getMessageEncoding(), new DecompressorInfo(d, advertised));
        if (previousInfo != null) {
            throw new IllegalArgumentException("A decompressor was already registered: " + previousInfo.decompressor);
        }
    }

    public static Set<String> getKnownMessageEncodings() {
        return INSTANCE.internalGetKnownMessageEncodings();
    }

    @VisibleForTesting
    Set<String> internalGetKnownMessageEncodings() {
        return Collections.unmodifiableSet(this.decompressors.keySet());
    }

    public static Set<String> getAdvertisedMessageEncodings() {
        return INSTANCE.internalGetAdvertisedMessageEncodings();
    }

    @VisibleForTesting
    Set<String> internalGetAdvertisedMessageEncodings() {
        HashSet advertisedDecompressors = new HashSet();
        for (Map.Entry entry : this.decompressors.entrySet()) {
            if (!((DecompressorInfo)entry.getValue()).advertised) continue;
            advertisedDecompressors.add(entry.getKey());
        }
        return Collections.unmodifiableSet(advertisedDecompressors);
    }

    @Nullable
    public static Decompressor lookupDecompressor(String messageEncoding) {
        return INSTANCE.internalLookupDecompressor(messageEncoding);
    }

    @Nullable
    @VisibleForTesting
    Decompressor internalLookupDecompressor(String messageEncoding) {
        DecompressorInfo info = (DecompressorInfo)this.decompressors.get(messageEncoding);
        return info != null ? info.decompressor : null;
    }

    @VisibleForTesting
    DecompressorRegistry() {
        Codec.Gzip gzip = new Codec.Gzip();
        this.decompressors.put(gzip.getMessageEncoding(), new DecompressorInfo(gzip, false));
        this.decompressors.put(Codec.Identity.NONE.getMessageEncoding(), new DecompressorInfo(Codec.Identity.NONE, false));
    }

    private static final class DecompressorInfo {
        private final Decompressor decompressor;
        private volatile boolean advertised;

        DecompressorInfo(Decompressor decompressor, boolean advertised) {
            this.decompressor = (Decompressor)Preconditions.checkNotNull((Object)decompressor);
            this.advertised = advertised;
        }
    }
}

