/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import io.grpc.internal.GrpcUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class Metadata {
    public static final String BINARY_HEADER_SUFFIX = "-bin";
    public static final AsciiMarshaller<String> ASCII_STRING_MARSHALLER = new AsciiMarshaller<String>(){

        @Override
        public String toAsciiString(String value) {
            return value;
        }

        @Override
        public String parseAsciiString(String serialized) {
            return serialized;
        }
    };
    static final AsciiMarshaller<Integer> INTEGER_MARSHALLER = new AsciiMarshaller<Integer>(){

        @Override
        public String toAsciiString(Integer value) {
            return value.toString();
        }

        @Override
        public Integer parseAsciiString(String serialized) {
            return Integer.parseInt(serialized);
        }
    };
    private final Map<String, List<MetadataEntry>> store = new LinkedHashMap<String, List<MetadataEntry>>();

    public Metadata(byte[] ... binaryValues) {
        for (int i = 0; i < binaryValues.length; ++i) {
            String name = new String(binaryValues[i], Charsets.US_ASCII);
            this.storeAdd(name, new MetadataEntry(name.endsWith(BINARY_HEADER_SUFFIX), binaryValues[++i]));
        }
    }

    public Metadata() {
    }

    private void storeAdd(String name, MetadataEntry value) {
        List<MetadataEntry> values = this.store.get(name);
        if (values == null) {
            values = new ArrayList<MetadataEntry>();
            this.store.put(name, values);
        }
        values.add(value);
    }

    public boolean containsKey(Key<?> key) {
        return this.store.containsKey(((Key)key).name);
    }

    public <T> T get(Key<T> key) {
        List<MetadataEntry> values = this.store.get(key.name());
        if (values == null) {
            return null;
        }
        MetadataEntry metadataEntry = values.get(values.size() - 1);
        return metadataEntry.getParsed(key);
    }

    public <T> Iterable<T> getAll(final Key<T> key) {
        if (this.containsKey(key)) {
            return Iterables.transform((Iterable)this.store.get(key.name()), (Function)new Function<MetadataEntry, T>(){

                public T apply(MetadataEntry entry) {
                    return entry.getParsed(key);
                }
            });
        }
        return null;
    }

    public <T> void put(Key<T> key, T value) {
        Preconditions.checkNotNull(key, (Object)"key");
        Preconditions.checkNotNull(value, (Object)"value");
        this.storeAdd(key.name(), new MetadataEntry(key, value));
    }

    public <T> boolean remove(Key<T> key, T value) {
        Preconditions.checkNotNull(key, (Object)"key");
        Preconditions.checkNotNull(value, (Object)"value");
        List<MetadataEntry> values = this.store.get(key.name());
        if (values == null) {
            return false;
        }
        for (int i = 0; i < values.size(); ++i) {
            MetadataEntry entry = values.get(i);
            if (!value.equals(entry.getParsed(key))) continue;
            values.remove(i);
            return true;
        }
        return false;
    }

    public <T> Iterable<T> removeAll(final Key<T> key) {
        List<MetadataEntry> values = this.store.remove(key.name());
        if (values == null) {
            return null;
        }
        return Iterables.transform(values, (Function)new Function<MetadataEntry, T>(){

            public T apply(MetadataEntry metadataEntry) {
                return metadataEntry.getParsed(key);
            }
        });
    }

    public byte[][] serialize() {
        ArrayList<byte[]> serialized = new ArrayList<byte[]>(this.store.size() * 2 * 2);
        for (Map.Entry<String, List<MetadataEntry>> keyEntry : this.store.entrySet()) {
            if (keyEntry.getKey().equals(GrpcUtil.AUTHORITY_KEY.name())) continue;
            for (int i = 0; i < keyEntry.getValue().size(); ++i) {
                MetadataEntry entry = keyEntry.getValue().get(i);
                byte[] asciiName = entry.key != null ? entry.key.asciiName() : keyEntry.getKey().getBytes(Charsets.US_ASCII);
                serialized.add(asciiName);
                serialized.add(entry.getSerialized());
            }
        }
        return (byte[][])serialized.toArray((T[])new byte[serialized.size()][]);
    }

    public void merge(Metadata other) {
        Preconditions.checkNotNull((Object)other);
        for (Map.Entry<String, List<MetadataEntry>> keyEntry : other.store.entrySet()) {
            for (int i = 0; i < keyEntry.getValue().size(); ++i) {
                this.storeAdd(keyEntry.getKey(), new MetadataEntry(keyEntry.getValue().get(i)));
            }
        }
    }

    public void merge(Metadata other, Set<Key<?>> keys) {
        Preconditions.checkNotNull((Object)other);
        for (Key<?> key : keys) {
            List<MetadataEntry> values = other.store.get(((Key)key).name);
            if (values == null) continue;
            for (int i = 0; i < values.size(); ++i) {
                this.storeAdd(((Key)key).name, new MetadataEntry(values.get(i)));
            }
        }
    }

    public String toString() {
        return "Metadata(" + this.toStringInternal() + ")";
    }

    private String toStringInternal() {
        return this.store.toString();
    }

    private static class MetadataEntry {
        Object parsed;
        Key key;
        boolean isBinary;
        byte[] serializedBinary;

        private MetadataEntry(Key<?> key, Object parsed) {
            this.parsed = Preconditions.checkNotNull((Object)parsed);
            this.key = (Key)Preconditions.checkNotNull(key);
            this.isBinary = key instanceof BinaryKey;
        }

        private MetadataEntry(boolean isBinary, byte[] serialized) {
            Preconditions.checkNotNull((Object)serialized);
            this.serializedBinary = serialized;
            this.isBinary = isBinary;
        }

        private MetadataEntry(MetadataEntry entry) {
            this.parsed = entry.parsed;
            this.key = entry.key;
            this.isBinary = entry.isBinary;
            this.serializedBinary = entry.serializedBinary;
        }

        public <T> T getParsed(Key<T> key) {
            Object value = this.parsed;
            if (value != null) {
                if (this.key != key) {
                    this.serializedBinary = this.key.toBytes(value);
                } else {
                    return (T)value;
                }
            }
            this.key = key;
            if (this.serializedBinary != null) {
                value = key.parseBytes(this.serializedBinary);
            }
            this.parsed = value;
            return (T)value;
        }

        public byte[] getSerialized() {
            this.serializedBinary = this.serializedBinary == null ? this.key.toBytes(this.parsed) : this.serializedBinary;
            return this.serializedBinary;
        }

        public String toString() {
            if (!this.isBinary) {
                return new String(this.getSerialized(), Charsets.US_ASCII);
            }
            if (this.parsed != null) {
                return "" + this.parsed;
            }
            return Arrays.toString(this.serializedBinary);
        }
    }

    private static class AsciiKey<T>
    extends Key<T> {
        private final AsciiMarshaller<T> marshaller;

        private AsciiKey(String name, AsciiMarshaller<T> marshaller) {
            super(name);
            Preconditions.checkArgument((!name.endsWith(Metadata.BINARY_HEADER_SUFFIX) ? 1 : 0) != 0, (Object)("ASCII header is named " + name + ". It must not end with " + Metadata.BINARY_HEADER_SUFFIX));
            this.marshaller = (AsciiMarshaller)Preconditions.checkNotNull(marshaller);
        }

        @Override
        byte[] toBytes(T value) {
            return this.marshaller.toAsciiString(value).getBytes(Charsets.US_ASCII);
        }

        @Override
        T parseBytes(byte[] serialized) {
            return this.marshaller.parseAsciiString(new String(serialized, Charsets.US_ASCII));
        }
    }

    private static class BinaryKey<T>
    extends Key<T> {
        private final BinaryMarshaller<T> marshaller;

        private BinaryKey(String name, BinaryMarshaller<T> marshaller) {
            super(name);
            Preconditions.checkArgument((boolean)name.endsWith(Metadata.BINARY_HEADER_SUFFIX), (Object)("Binary header is named " + name + ". It must end with " + Metadata.BINARY_HEADER_SUFFIX));
            this.marshaller = (BinaryMarshaller)Preconditions.checkNotNull(marshaller);
        }

        @Override
        byte[] toBytes(T value) {
            return this.marshaller.toBytes(value);
        }

        @Override
        T parseBytes(byte[] serialized) {
            return this.marshaller.parseBytes(serialized);
        }
    }

    public static abstract class Key<T> {
        private final String name;
        private final byte[] asciiName;

        public static <T> Key<T> of(String name, BinaryMarshaller<T> marshaller) {
            return new BinaryKey(name, marshaller);
        }

        public static <T> Key<T> of(String name, AsciiMarshaller<T> marshaller) {
            return new AsciiKey(name, marshaller);
        }

        private Key(String name) {
            this.name = ((String)Preconditions.checkNotNull((Object)name, (Object)"name")).toLowerCase(Locale.ROOT).intern();
            this.asciiName = this.name.getBytes(Charsets.US_ASCII);
        }

        public String name() {
            return this.name;
        }

        @VisibleForTesting
        byte[] asciiName() {
            return this.asciiName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.name.equals(key.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return "Key{name='" + this.name + "'}";
        }

        abstract byte[] toBytes(T var1);

        abstract T parseBytes(byte[] var1);
    }

    public static interface AsciiMarshaller<T> {
        public String toAsciiString(T var1);

        public T parseAsciiString(String var1);
    }

    public static interface BinaryMarshaller<T> {
        public byte[] toBytes(T var1);

        public T parseBytes(byte[] var1);
    }
}

