/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import java.util.HashSet;
import javax.annotation.concurrent.GuardedBy;

abstract class InUseStateAggregator<T> {
    @GuardedBy(value="getLock()")
    private final HashSet<T> inUseObjects = new HashSet();

    InUseStateAggregator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void updateObjectInUse(T object, boolean inUse) {
        Object object2 = this.getLock();
        synchronized (object2) {
            int origSize = this.inUseObjects.size();
            if (inUse) {
                this.inUseObjects.add(object);
                if (origSize == 0) {
                    this.handleInUse();
                }
            } else {
                boolean removed = this.inUseObjects.remove(object);
                if (removed && origSize == 1) {
                    this.handleNotInUse();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean isInUse() {
        Object object = this.getLock();
        synchronized (object) {
            return !this.inUseObjects.isEmpty();
        }
    }

    abstract Object getLock();

    @GuardedBy(value="getLock()")
    abstract void handleInUse();

    @GuardedBy(value="getLock()")
    abstract void handleNotInUse();
}

