/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import com.google.common.base.Supplier;
import io.grpc.Attributes;
import io.grpc.EquivalentAddressGroup;
import io.grpc.LoadBalancer;
import io.grpc.ResolvedServerInfo;
import io.grpc.ResolvedServerInfoGroup;
import io.grpc.Status;
import io.grpc.TransportManager;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;

public final class PickFirstBalancerFactory
extends LoadBalancer.Factory {
    private static final PickFirstBalancerFactory instance = new PickFirstBalancerFactory();

    private PickFirstBalancerFactory() {
    }

    public static PickFirstBalancerFactory getInstance() {
        return instance;
    }

    @Override
    public <T> LoadBalancer<T> newLoadBalancer(String serviceName, TransportManager<T> tm) {
        return new PickFirstBalancer(tm);
    }

    private static class PickFirstBalancer<T>
    extends LoadBalancer<T> {
        private static final Status SHUTDOWN_STATUS = Status.UNAVAILABLE.augmentDescription("PickFirstBalancer has shut down");
        private final Object lock = new Object();
        private volatile EquivalentAddressGroup addresses;
        @GuardedBy(value="lock")
        private TransportManager.InterimTransport<T> interimTransport;
        @GuardedBy(value="lock")
        private Status nameResolutionError;
        @GuardedBy(value="lock")
        private boolean closed;
        private final TransportManager<T> tm;

        private PickFirstBalancer(TransportManager<T> tm) {
            this.tm = tm;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T pickTransport(Attributes affinity) {
            EquivalentAddressGroup addressesCopy = this.addresses;
            if (addressesCopy != null) {
                return this.tm.getTransport(addressesCopy);
            }
            Object object = this.lock;
            synchronized (object) {
                if (this.closed) {
                    return this.tm.createFailingTransport(SHUTDOWN_STATUS);
                }
                addressesCopy = this.addresses;
                if (addressesCopy == null) {
                    if (this.nameResolutionError != null) {
                        return this.tm.createFailingTransport(this.nameResolutionError);
                    }
                    if (this.interimTransport == null) {
                        this.interimTransport = this.tm.createInterimTransport();
                    }
                    return this.interimTransport.transport();
                }
            }
            return this.tm.getTransport(addressesCopy);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleResolvedAddresses(List<ResolvedServerInfoGroup> updatedServers, Attributes attributes) {
            TransportManager.InterimTransport<T> savedInterimTransport;
            EquivalentAddressGroup newAddresses;
            Object object = this.lock;
            synchronized (object) {
                if (this.closed) {
                    return;
                }
                newAddresses = PickFirstBalancer.resolvedServerInfoGroupsToEquivalentAddressGroup(updatedServers);
                if (newAddresses.equals(this.addresses)) {
                    return;
                }
                this.addresses = newAddresses;
                this.nameResolutionError = null;
                savedInterimTransport = this.interimTransport;
                this.interimTransport = null;
            }
            if (savedInterimTransport != null) {
                savedInterimTransport.closeWithRealTransports(new Supplier<T>(){

                    public T get() {
                        return PickFirstBalancer.this.tm.getTransport(newAddresses);
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleNameResolutionError(Status error) {
            TransportManager.InterimTransport<T> savedInterimTransport;
            Object object = this.lock;
            synchronized (object) {
                if (this.closed) {
                    return;
                }
                error = error.augmentDescription("Name resolution failed");
                savedInterimTransport = this.interimTransport;
                this.interimTransport = null;
                this.nameResolutionError = error;
            }
            if (savedInterimTransport != null) {
                savedInterimTransport.closeWithError(error);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void shutdown() {
            TransportManager.InterimTransport<T> savedInterimTransport;
            Object object = this.lock;
            synchronized (object) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                this.addresses = null;
                savedInterimTransport = this.interimTransport;
                this.interimTransport = null;
            }
            if (savedInterimTransport != null) {
                savedInterimTransport.closeWithError(SHUTDOWN_STATUS);
            }
        }

        private static EquivalentAddressGroup resolvedServerInfoGroupsToEquivalentAddressGroup(List<ResolvedServerInfoGroup> groupList) {
            ArrayList<SocketAddress> addrs = new ArrayList<SocketAddress>(groupList.size());
            for (ResolvedServerInfoGroup group : groupList) {
                for (ResolvedServerInfo srv : group.getResolvedServerInfoList()) {
                    addrs.add(srv.getAddress());
                }
            }
            return new EquivalentAddressGroup(addrs);
        }
    }
}

