/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import io.grpc.NameResolver;
import io.grpc.internal.ForwardingNameResolver;
import java.net.URI;
import javax.annotation.Nullable;

final class OverrideAuthorityNameResolverFactory
extends NameResolver.Factory {
    private final NameResolver.Factory delegate;
    private final String authorityOverride;

    OverrideAuthorityNameResolverFactory(NameResolver.Factory delegate, String authorityOverride) {
        this.delegate = delegate;
        this.authorityOverride = authorityOverride;
    }

    @Nullable
    public NameResolver newNameResolver(URI targetUri, NameResolver.Args args) {
        NameResolver resolver = this.delegate.newNameResolver(targetUri, args);
        if (resolver == null) {
            return null;
        }
        return new ForwardingNameResolver(resolver){

            @Override
            public String getServiceAuthority() {
                return OverrideAuthorityNameResolverFactory.this.authorityOverride;
            }
        };
    }

    public String getDefaultScheme() {
        return this.delegate.getDefaultScheme();
    }
}

