/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.instrumentation.trace.BinaryPropagationHandler;
import com.google.instrumentation.trace.ContextUtils;
import com.google.instrumentation.trace.EndSpanOptions;
import com.google.instrumentation.trace.Span;
import com.google.instrumentation.trace.SpanContext;
import com.google.instrumentation.trace.Tracer;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ClientStreamTracer;
import io.grpc.Context;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerStreamTracer;
import io.grpc.Status;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

final class CensusTracingModule {
    private static final Logger logger = Logger.getLogger(CensusTracingModule.class.getName());
    private static final ClientStreamTracer noopClientTracer = new ClientStreamTracer(){};
    private final Tracer censusTracer;
    private final BinaryPropagationHandler censusTracingPropagationHandler;
    @VisibleForTesting
    final Metadata.Key<SpanContext> tracingHeader;
    private final TracingClientInterceptor clientInterceptor = new TracingClientInterceptor();
    private final ServerTracerFactory serverTracerFactory = new ServerTracerFactory();

    CensusTracingModule(Tracer censusTracer, final BinaryPropagationHandler censusTracingPropagationHandler) {
        this.censusTracer = (Tracer)Preconditions.checkNotNull((Object)censusTracer, (Object)"censusTracer");
        this.censusTracingPropagationHandler = (BinaryPropagationHandler)Preconditions.checkNotNull((Object)censusTracingPropagationHandler, (Object)"censusTracingPropagationHandler");
        this.tracingHeader = Metadata.Key.of("grpc-trace-bin", new Metadata.BinaryMarshaller<SpanContext>(){

            @Override
            public byte[] toBytes(SpanContext context) {
                return censusTracingPropagationHandler.toBinaryValue(context);
            }

            @Override
            public SpanContext parseBytes(byte[] serialized) {
                try {
                    return censusTracingPropagationHandler.fromBinaryValue(serialized);
                }
                catch (Exception e) {
                    logger.log(Level.FINE, "Failed to parse tracing header", e);
                    return SpanContext.INVALID;
                }
            }
        });
    }

    @VisibleForTesting
    ClientCallTracer newClientCallTracer(@Nullable Span parentSpan, String fullMethodName) {
        return new ClientCallTracer(parentSpan, fullMethodName);
    }

    ServerStreamTracer.Factory getServerTracerFactory() {
        return this.serverTracerFactory;
    }

    ClientInterceptor getClientInterceptor() {
        return this.clientInterceptor;
    }

    private static String makeSpanName(String prefix, String fullMethodName) {
        return prefix + "." + fullMethodName.replace('/', '.');
    }

    @VisibleForTesting
    static com.google.instrumentation.trace.Status convertStatus(Status grpcStatus) {
        com.google.instrumentation.trace.Status status;
        switch (grpcStatus.getCode()) {
            case OK: {
                status = com.google.instrumentation.trace.Status.OK;
                break;
            }
            case CANCELLED: {
                status = com.google.instrumentation.trace.Status.CANCELLED;
                break;
            }
            case UNKNOWN: {
                status = com.google.instrumentation.trace.Status.UNKNOWN;
                break;
            }
            case INVALID_ARGUMENT: {
                status = com.google.instrumentation.trace.Status.INVALID_ARGUMENT;
                break;
            }
            case DEADLINE_EXCEEDED: {
                status = com.google.instrumentation.trace.Status.DEADLINE_EXCEEDED;
                break;
            }
            case NOT_FOUND: {
                status = com.google.instrumentation.trace.Status.NOT_FOUND;
                break;
            }
            case ALREADY_EXISTS: {
                status = com.google.instrumentation.trace.Status.ALREADY_EXISTS;
                break;
            }
            case PERMISSION_DENIED: {
                status = com.google.instrumentation.trace.Status.PERMISSION_DENIED;
                break;
            }
            case RESOURCE_EXHAUSTED: {
                status = com.google.instrumentation.trace.Status.RESOURCE_EXHAUSTED;
                break;
            }
            case FAILED_PRECONDITION: {
                status = com.google.instrumentation.trace.Status.FAILED_PRECONDITION;
                break;
            }
            case ABORTED: {
                status = com.google.instrumentation.trace.Status.ABORTED;
                break;
            }
            case OUT_OF_RANGE: {
                status = com.google.instrumentation.trace.Status.OUT_OF_RANGE;
                break;
            }
            case UNIMPLEMENTED: {
                status = com.google.instrumentation.trace.Status.UNIMPLEMENTED;
                break;
            }
            case INTERNAL: {
                status = com.google.instrumentation.trace.Status.INTERNAL;
                break;
            }
            case UNAVAILABLE: {
                status = com.google.instrumentation.trace.Status.UNAVAILABLE;
                break;
            }
            case DATA_LOSS: {
                status = com.google.instrumentation.trace.Status.DATA_LOSS;
                break;
            }
            case UNAUTHENTICATED: {
                status = com.google.instrumentation.trace.Status.UNAUTHENTICATED;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unhandled status code " + (Object)((Object)grpcStatus.getCode())));
            }
        }
        if (grpcStatus.getDescription() != null) {
            status = status.withDescription(grpcStatus.getDescription());
        }
        return status;
    }

    private static EndSpanOptions createEndSpanOptions(Status status) {
        return EndSpanOptions.builder().setStatus(CensusTracingModule.convertStatus(status)).build();
    }

    private class TracingClientInterceptor
    implements ClientInterceptor {
        private TracingClientInterceptor() {
        }

        @Override
        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
            Span parentSpan = (Span)ContextUtils.CONTEXT_SPAN_KEY.get();
            final ClientCallTracer tracerFactory = CensusTracingModule.this.newClientCallTracer(parentSpan, method.getFullMethodName());
            ClientCall<ReqT, RespT> call = next.newCall(method, callOptions.withStreamTracerFactory(tracerFactory));
            return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(call){

                @Override
                public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                    this.delegate().start(new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                        @Override
                        public void onClose(Status status, Metadata trailers) {
                            tracerFactory.callEnded(status);
                            super.onClose(status, trailers);
                        }
                    }, headers);
                }
            };
        }
    }

    private final class ServerTracerFactory
    extends ServerStreamTracer.Factory {
        private ServerTracerFactory() {
        }

        @Override
        public ServerStreamTracer newServerStreamTracer(String fullMethodName, Metadata headers) {
            SpanContext remoteSpan = headers.get(CensusTracingModule.this.tracingHeader);
            if (remoteSpan == SpanContext.INVALID) {
                remoteSpan = null;
            }
            return new ServerTracer(fullMethodName, remoteSpan);
        }
    }

    private final class ServerTracer
    extends ServerStreamTracer {
        private final String fullMethodName;
        private final Span span;
        private final AtomicBoolean streamClosed = new AtomicBoolean(false);

        ServerTracer(@Nullable String fullMethodName, SpanContext remoteSpan) {
            this.fullMethodName = (String)Preconditions.checkNotNull((Object)fullMethodName, (Object)"fullMethodName");
            this.span = CensusTracingModule.this.censusTracer.spanBuilderWithRemoteParent(remoteSpan, CensusTracingModule.makeSpanName("Recv", fullMethodName)).setRecordEvents(true).startSpan();
        }

        @Override
        public void streamClosed(Status status) {
            if (!this.streamClosed.compareAndSet(false, true)) {
                return;
            }
            this.span.end(CensusTracingModule.createEndSpanOptions(status));
        }

        @Override
        public <ReqT, RespT> Context filterContext(Context context) {
            return context.withValue(ContextUtils.CONTEXT_SPAN_KEY, (Object)this.span);
        }
    }

    @VisibleForTesting
    final class ClientCallTracer
    extends ClientStreamTracer.Factory {
        private final String fullMethodName;
        private final AtomicBoolean callEnded = new AtomicBoolean(false);
        private final Span span;

        ClientCallTracer(Span parentSpan, String fullMethodName) {
            this.fullMethodName = (String)Preconditions.checkNotNull((Object)fullMethodName, (Object)"fullMethodName");
            this.span = CensusTracingModule.this.censusTracer.spanBuilder(parentSpan, CensusTracingModule.makeSpanName("Sent", fullMethodName)).setRecordEvents(true).startSpan();
        }

        @Override
        public ClientStreamTracer newClientStreamTracer(Metadata headers) {
            headers.discardAll(CensusTracingModule.this.tracingHeader);
            headers.put(CensusTracingModule.this.tracingHeader, this.span.getContext());
            return noopClientTracer;
        }

        void callEnded(Status status) {
            if (!this.callEnded.compareAndSet(false, true)) {
                return;
            }
            this.span.end(CensusTracingModule.createEndSpanOptions(status));
        }
    }
}

