/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.Codec;
import io.grpc.Compressor;
import io.grpc.Decompressor;
import io.grpc.DecompressorRegistry;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.internal.AbstractStream;
import io.grpc.internal.ClientStream;
import io.grpc.internal.ClientStreamListener;
import io.grpc.internal.Framer;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.IoUtils;
import io.grpc.internal.MessageFramer;
import io.grpc.internal.ReadableBuffer;
import io.grpc.internal.StatsTraceContext;
import io.grpc.internal.WritableBuffer;
import io.grpc.internal.WritableBufferAllocator;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public abstract class AbstractClientStream
extends AbstractStream
implements ClientStream,
MessageFramer.Sink {
    private static final Logger log = Logger.getLogger(AbstractClientStream.class.getName());
    private final Framer framer;
    private boolean useGet;
    private Metadata headers;
    private boolean outboundClosed;
    private volatile boolean cancelled;

    protected AbstractClientStream(WritableBufferAllocator bufferAllocator, StatsTraceContext statsTraceCtx, Metadata headers, boolean useGet) {
        Preconditions.checkNotNull((Object)headers, (Object)"headers");
        this.useGet = useGet;
        if (!useGet) {
            this.framer = new MessageFramer(this, bufferAllocator, statsTraceCtx);
            this.headers = headers;
        } else {
            this.framer = new GetFramer(headers, statsTraceCtx);
        }
    }

    @Override
    public void setMaxOutboundMessageSize(int maxSize) {
        this.framer.setMaxOutboundMessageSize(maxSize);
    }

    @Override
    public void setMaxInboundMessageSize(int maxSize) {
        this.transportState().setMaxInboundMessageSize(maxSize);
    }

    @Override
    public final void setDecompressorRegistry(DecompressorRegistry decompressorRegistry) {
        this.transportState().setDecompressorRegistry(decompressorRegistry);
    }

    @Override
    protected abstract TransportState transportState();

    @Override
    public final void start(ClientStreamListener listener) {
        this.transportState().setListener(listener);
        if (!this.useGet) {
            this.abstractClientStreamSink().writeHeaders(this.headers, null);
            this.headers = null;
        }
    }

    protected abstract Sink abstractClientStreamSink();

    @Override
    protected final Framer framer() {
        return this.framer;
    }

    @Override
    public final void request(int numMessages) {
        this.abstractClientStreamSink().request(numMessages);
    }

    @Override
    public final void deliverFrame(WritableBuffer frame, boolean endOfStream, boolean flush) {
        Preconditions.checkArgument((frame != null || endOfStream ? 1 : 0) != 0, (Object)"null frame before EOS");
        this.abstractClientStreamSink().writeFrame(frame, endOfStream, flush);
    }

    @Override
    public final void halfClose() {
        if (!this.outboundClosed) {
            this.outboundClosed = true;
            this.endOfMessages();
        }
    }

    @Override
    public final void cancel(Status reason) {
        Preconditions.checkArgument((!reason.isOk() ? 1 : 0) != 0, (Object)"Should not cancel with OK status");
        this.cancelled = true;
        this.abstractClientStreamSink().cancel(reason);
    }

    @Override
    public final boolean isReady() {
        return super.isReady() && !this.cancelled;
    }

    private class GetFramer
    implements Framer {
        private Metadata headers;
        private boolean closed;
        private final StatsTraceContext statsTraceCtx;
        private byte[] payload;

        public GetFramer(Metadata headers, StatsTraceContext statsTraceCtx) {
            this.headers = (Metadata)Preconditions.checkNotNull((Object)headers, (Object)"headers");
            this.statsTraceCtx = (StatsTraceContext)Preconditions.checkNotNull((Object)statsTraceCtx, (Object)"statsTraceCtx");
        }

        @Override
        public void writePayload(InputStream message) {
            Preconditions.checkState((this.payload == null ? 1 : 0) != 0, (Object)"writePayload should not be called multiple times");
            try {
                this.payload = IoUtils.toByteArray(message);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            this.statsTraceCtx.outboundMessage();
            this.statsTraceCtx.outboundUncompressedSize(this.payload.length);
            this.statsTraceCtx.outboundWireSize(this.payload.length);
        }

        @Override
        public void flush() {
        }

        @Override
        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public void close() {
            this.closed = true;
            Preconditions.checkState((this.payload != null ? 1 : 0) != 0, (Object)"Lack of request message. GET request is only supported for unary requests");
            AbstractClientStream.this.abstractClientStreamSink().writeHeaders(this.headers, this.payload);
            this.payload = null;
            this.headers = null;
        }

        @Override
        public void dispose() {
            this.closed = true;
            this.payload = null;
            this.headers = null;
        }

        @Override
        public Framer setMessageCompression(boolean enable) {
            return this;
        }

        @Override
        public Framer setCompressor(Compressor compressor) {
            return this;
        }

        @Override
        public void setMaxOutboundMessageSize(int maxSize) {
        }
    }

    protected static abstract class TransportState
    extends AbstractStream.TransportState {
        private final StatsTraceContext statsTraceCtx;
        private boolean listenerClosed;
        private ClientStreamListener listener;
        private DecompressorRegistry decompressorRegistry = DecompressorRegistry.getDefaultInstance();
        private boolean deframerClosed = false;
        private Runnable deframerClosedTask;
        private boolean statusReported;

        protected TransportState(int maxMessageSize, StatsTraceContext statsTraceCtx) {
            super(maxMessageSize, statsTraceCtx);
            this.statsTraceCtx = (StatsTraceContext)Preconditions.checkNotNull((Object)statsTraceCtx, (Object)"statsTraceCtx");
        }

        private void setDecompressorRegistry(DecompressorRegistry decompressorRegistry) {
            Preconditions.checkState((this.listener == null ? 1 : 0) != 0, (Object)"Already called start");
            this.decompressorRegistry = (DecompressorRegistry)Preconditions.checkNotNull((Object)decompressorRegistry, (Object)"decompressorRegistry");
        }

        @VisibleForTesting
        public final void setListener(ClientStreamListener listener) {
            Preconditions.checkState((this.listener == null ? 1 : 0) != 0, (Object)"Already called setListener");
            this.listener = (ClientStreamListener)Preconditions.checkNotNull((Object)listener, (Object)"listener");
        }

        @Override
        public void deframerClosed(boolean hasPartialMessageIgnored) {
            this.deframerClosed = true;
            if (this.deframerClosedTask != null) {
                this.deframerClosedTask.run();
                this.deframerClosedTask = null;
            }
        }

        @Override
        protected final ClientStreamListener listener() {
            return this.listener;
        }

        protected void inboundHeadersReceived(Metadata headers) {
            Preconditions.checkState((!this.statusReported ? 1 : 0) != 0, (Object)"Received headers on closed stream");
            this.statsTraceCtx.clientInboundHeaders();
            Decompressor decompressor = Codec.Identity.NONE;
            String encoding = headers.get(GrpcUtil.MESSAGE_ENCODING_KEY);
            if (encoding != null && (decompressor = this.decompressorRegistry.lookupDecompressor(encoding)) == null) {
                this.deframeFailed(Status.INTERNAL.withDescription(String.format("Can't find decompressor for %s", encoding)).asRuntimeException());
                return;
            }
            this.setDecompressor(decompressor);
            this.listener().headersRead(headers);
        }

        protected void inboundDataReceived(ReadableBuffer frame) {
            Preconditions.checkNotNull((Object)frame, (Object)"frame");
            boolean needToCloseFrame = true;
            try {
                if (this.statusReported) {
                    log.log(Level.INFO, "Received data on closed stream");
                    return;
                }
                needToCloseFrame = false;
                this.deframe(frame);
            }
            finally {
                if (needToCloseFrame) {
                    frame.close();
                }
            }
        }

        protected void inboundTrailersReceived(Metadata trailers, Status status) {
            Preconditions.checkNotNull((Object)status, (Object)"status");
            Preconditions.checkNotNull((Object)trailers, (Object)"trailers");
            if (this.statusReported) {
                log.log(Level.INFO, "Received trailers on closed stream:\n {1}\n {2}", new Object[]{status, trailers});
                return;
            }
            this.transportReportStatus(status, false, trailers);
        }

        public final void transportReportStatus(final Status status, boolean stopDelivery, final Metadata trailers) {
            Preconditions.checkNotNull((Object)status, (Object)"status");
            Preconditions.checkNotNull((Object)trailers, (Object)"trailers");
            if (this.statusReported && !stopDelivery) {
                return;
            }
            this.statusReported = true;
            this.onStreamDeallocated();
            if (this.deframerClosed) {
                this.deframerClosedTask = null;
                this.closeListener(status, trailers);
            } else {
                this.deframerClosedTask = new Runnable(){

                    @Override
                    public void run() {
                        TransportState.this.closeListener(status, trailers);
                    }
                };
                this.closeDeframer(stopDelivery);
            }
        }

        private void closeListener(Status status, Metadata trailers) {
            if (!this.listenerClosed) {
                this.listenerClosed = true;
                this.statsTraceCtx.streamClosed(status);
                this.listener().closed(status, trailers);
            }
        }
    }

    protected static interface Sink {
        public void writeHeaders(Metadata var1, @Nullable byte[] var2);

        public void writeFrame(@Nullable WritableBuffer var1, boolean var2, boolean var3);

        public void request(int var1);

        public void cancel(Status var1);
    }
}

