/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.annotations.VisibleForTesting;
import io.grpc.InternalChannelStats;
import io.grpc.internal.LongCounter;
import io.grpc.internal.LongCounterFactory;

final class ChannelTracer {
    private final TimeProvider timeProvider;
    private final LongCounter callsStarted = LongCounterFactory.create();
    private final LongCounter callsSucceeded = LongCounterFactory.create();
    private final LongCounter callsFailed = LongCounterFactory.create();
    private volatile long lastCallStartedMillis;
    static final TimeProvider SYSTEM_TIME_PROVIDER = new TimeProvider(){

        @Override
        public long currentTimeMillis() {
            return System.currentTimeMillis();
        }
    };
    static final Factory DEFAULT_FACTORY = new Factory(){

        @Override
        public ChannelTracer create() {
            return new ChannelTracer(SYSTEM_TIME_PROVIDER);
        }
    };

    ChannelTracer(TimeProvider timeProvider) {
        this.timeProvider = timeProvider;
    }

    public void reportCallStarted() {
        this.callsStarted.add(1L);
        this.lastCallStartedMillis = this.timeProvider.currentTimeMillis();
    }

    public void reportCallEnded(boolean success) {
        if (success) {
            this.callsSucceeded.add(1L);
        } else {
            this.callsFailed.add(1L);
        }
    }

    public InternalChannelStats getStats() {
        return new InternalChannelStats(this.callsStarted.value(), this.callsSucceeded.value(), this.callsFailed.value(), this.lastCallStartedMillis);
    }

    public static Factory getDefaultFactory() {
        return DEFAULT_FACTORY;
    }

    public static interface Factory {
        public ChannelTracer create();
    }

    @VisibleForTesting
    static interface TimeProvider {
        public long currentTimeMillis();
    }
}

