/*
 * Decompiled with CFR 0.152.
 */
package io.idmlrepl;

import io.idml.FunctionResolverService;
import io.idml.Ptolemy;
import io.idml.PtolemyConf;
import io.idml.PtolemyJson$;
import io.idml.PtolemyMapping;
import io.idml.PtolemyObject;
import io.idml.PtolemyValue;
import io.idml.datanodes.PObject;
import io.idmlrepl.Repl;
import java.io.PrintWriter;
import java.io.Serializable;
import org.mockito.Matchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.FunSpec;
import org.scalatest.FunSpecLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.mockito.MockitoSugar;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.tools.jline.TerminalFactory;

@ScalaSignature(bytes="\u0006\u0001\u0005me\u0001B\u0001\u0003\u0001\u001d\u0011\u0001BU3qYR+7\u000f\u001e\u0006\u0003\u0007\u0011\t\u0001\"\u001b3nYJ,\u0007\u000f\u001c\u0006\u0002\u000b\u0005\u0011\u0011n\\\u0002\u0001'\u0011\u0001\u0001\u0002\u0005\u0012\u0011\u0005%qQ\"\u0001\u0006\u000b\u0005-a\u0011!C:dC2\fG/Z:u\u0015\u0005i\u0011aA8sO&\u0011qB\u0003\u0002\b\rVt7\u000b]3d!\t\trD\u0004\u0002\u001399\u00111C\u0007\b\u0003)eq!!\u0006\r\u000e\u0003YQ!a\u0006\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0011BA\u0006\r\u0013\tY\"\"\u0001\u0003n_\u000e\\\u0017BA\u000f\u001f\u0003\u001d\u0001\u0018mY6bO\u0016T!a\u0007\u0006\n\u0005\u0001\n#\u0001D'pG.LGo\\*vO\u0006\u0014(BA\u000f\u001f!\tI1%\u0003\u0002%\u0015\t\t\")\u001a4pe\u0016\fe\u000eZ!gi\u0016\u0014\u0018\t\u001c7\t\u000b\u0019\u0002A\u0011A\u0014\u0002\rqJg.\u001b;?)\u0005A\u0003CA\u0015\u0001\u001b\u0005\u0011\u0001\"B\u0016\u0001\t\u0003b\u0013\u0001C1gi\u0016\u0014\u0018\t\u001c7\u0015\u00035\u0002\"AL\u0019\u000e\u0003=R\u0011\u0001M\u0001\u0006g\u000e\fG.Y\u0005\u0003e=\u0012A!\u00168ji\u001a9A\u0007\u0001I\u0001$\u0003)$\u0001B7pG.\u001c\"a\r\u001c\u0011\u00059:\u0014B\u0001\u001d0\u0005\u0019\te.\u001f*fM\u001a!!\b\u0001\u0001<\u0005!!Vm\u001d;SKBd7CA\u001d=!\tIS(\u0003\u0002?\u0005\t!!+\u001a9m\u0011\u00151\u0013\b\"\u0001A)\u0005\t\u0005C\u0001\":\u001b\u0005\u0001\u0001b\u0002#:\u0005\u0004%\t%R\u0001\u0004_V$X#\u0001$\u0011\u0005\u001d[U\"\u0001%\u000b\u0005\u0015I%\"\u0001&\u0002\t)\fg/Y\u0005\u0003\u0019\"\u00131\u0002\u0015:j]R<&/\u001b;fe\"1a*\u000fQ\u0001\n\u0019\u000bAa\\;uA!9\u0001+\u000fb\u0001\n\u0003\n\u0016\u0001D%E\u001b2{f+\u0012*T\u0013>sU#\u0001*\u0011\u0005M3V\"\u0001+\u000b\u0005UK\u0015\u0001\u00027b]\u001eL!a\u0016+\u0003\rM#(/\u001b8h\u0011\u0019I\u0016\b)A\u0005%\u0006i\u0011\nR'M?Z+%kU%P\u001d\u0002BqaW\u001dC\u0002\u0013\u0005\u0013+\u0001\u0006C+&cEi\u0018#B)\u0016Ca!X\u001d!\u0002\u0013\u0011\u0016a\u0003\"V\u00132#u\fR!U\u000b\u0002Bqa\u0018\u0001C\u0002\u0013\u0005\u0011+A\u0007W\u000bJ\u001b\u0016j\u0014(`-\u0006c\u0015\n\u0012\u0005\u0007C\u0002\u0001\u000b\u0011\u0002*\u0002\u001dY+%kU%P\u001d~3\u0016\tT%EA!91\r\u0001b\u0001\n\u0003\t\u0016AE%E\u001b2{f+\u0012*T\u0013>suLV!M\u0013\u0012Ca!\u001a\u0001!\u0002\u0013\u0011\u0016aE%E\u001b2{f+\u0012*T\u0013>suLV!M\u0013\u0012\u0003\u0003bB4\u0001\u0005\u0004%\t!U\u0001\u0011\u0005VKE\nR0E\u0003R+uLV!M\u0013\u0012Ca!\u001b\u0001!\u0002\u0013\u0011\u0016!\u0005\"V\u00132#u\fR!U\u000b~3\u0016\tT%EA!91\u000e\u0001b\u0001\n\u0003\t\u0016\u0001E+O\u0017:{uKT0Q%>\u0003VI\u0015+Z\u0011\u0019i\u0007\u0001)A\u0005%\u0006\tRKT&O\u001f^su\f\u0015*P!\u0016\u0013F+\u0017\u0011\t\u000f=\u0004!\u0019!C\u0001#\u0006Q\u0011J\u0014)V)~S5k\u0014(\t\rE\u0004\u0001\u0015!\u0003S\u0003-Ie\nU+U?*\u001bvJ\u0014\u0011\t\u000fM\u0004!\u0019!C\u0001#\u0006Q\u0011J\u0014)V)~KE)\u0014'\t\rU\u0004\u0001\u0015!\u0003S\u0003-Ie\nU+U?&#U\n\u0014\u0011\t\u000f]\u0004!\u0019!C\u0001#\u0006a\u0011J\u0014)V)~\u001b6\tS#N\u0003\"1\u0011\u0010\u0001Q\u0001\nI\u000bQ\"\u0013(Q+R{6k\u0011%F\u001b\u0006\u0003\u0003bB>\u0001\u0005\u0004%\t!U\u0001\u0010\u0013:\u0003V\u000bV0N\u001f\u0012+uLS*P\u001d\"1Q\u0010\u0001Q\u0001\nI\u000b\u0001#\u0013(Q+R{Vj\u0014#F?*\u001bvJ\u0014\u0011\t\u000f}\u0004!\u0019!C\u0001#\u0006y\u0011J\u0014)V)~ku\nR#`\u0013\u0012kE\nC\u0004\u0002\u0004\u0001\u0001\u000b\u0011\u0002*\u0002!%s\u0005+\u0016+`\u001b>#UiX%E\u001b2\u0003\u0003\u0002CA\u0004\u0001\t\u0007I\u0011A)\u0002#%s\u0005+\u0016+`\u001b>#UiX*D\u0011\u0016k\u0015\tC\u0004\u0002\f\u0001\u0001\u000b\u0011\u0002*\u0002%%s\u0005+\u0016+`\u001b>#UiX*D\u0011\u0016k\u0015\t\t\u0005\t\u0003\u001f\u0001!\u0019!C\u0001#\u0006\u0011\u0012J\u0014)V)~ku\nR#`\u0013:3\u0016\tT%E\u0011\u001d\t\u0019\u0002\u0001Q\u0001\nI\u000b1#\u0013(Q+R{Vj\u0014#F?&se+\u0011'J\t\u0002B\u0001\"a\u0006\u0001\u0005\u0004%\t!U\u0001\u0019!J{5)R*T?&s\u0005+\u0016+`\u000bJ\u0013v\f\u0015*F\r&C\u0006bBA\u000e\u0001\u0001\u0006IAU\u0001\u001a!J{5)R*T?&s\u0005+\u0016+`\u000bJ\u0013v\f\u0015*F\r&C\u0006\u0005\u0003\u0005\u0002 \u0001\u0011\r\u0011\"\u0001R\u0003e\u0001&kT\"F'N{\u0016J\u0014)V)~+%KU0Q\u001fN#f)\u0013-\t\u000f\u0005\r\u0002\u0001)A\u0005%\u0006Q\u0002KU(D\u000bN\u001bv,\u0013(Q+R{VI\u0015*`!>\u001bFKR%YA!A\u0011q\u0005\u0001C\u0002\u0013\u0005\u0011+A\u000bQ%>\u001bUiU*`\u0015N{ejX!D\u0007\u0016\u0003F+\u0012#\t\u000f\u0005-\u0002\u0001)A\u0005%\u00061\u0002KU(D\u000bN\u001bvLS*P\u001d~\u000b5iQ#Q)\u0016#\u0005\u0005\u0003\u0005\u00020\u0001\u0011\r\u0011\"\u0001R\u0003e\u0001&kT\"F'N{&jU(O?\u0016\u0013&k\u0014*`!J+e)\u0013-\t\u000f\u0005M\u0002\u0001)A\u0005%\u0006Q\u0002KU(D\u000bN\u001bvLS*P\u001d~+%KU(S?B\u0013VIR%YA!A\u0011q\u0007\u0001C\u0002\u0013\u0005\u0011+\u0001\fQ%>\u001bUiU*`\u0015N{ejX#Y\u0007\u0016\u0003F+S(O\u0011\u001d\tY\u0004\u0001Q\u0001\nI\u000bq\u0003\u0015*P\u0007\u0016\u001b6k\u0018&T\u001f:{V\tW\"F!RKuJ\u0014\u0011\t\u0011\u0005}\u0002A1A\u0005\u0002E\u000b\u0011\u0004\u0015*P\u0007\u0016\u001b6kX%E\u001b2{VI\u0015*P%~\u0003&+\u0012$J1\"9\u00111\t\u0001!\u0002\u0013\u0011\u0016A\u0007)S\u001f\u000e+5kU0J\t6cu,\u0012*S\u001fJ{\u0006KU#G\u0013b\u0003\u0003\u0002CA$\u0001\t\u0007I\u0011A)\u0002-A\u0013vjQ#T'~KE)\u0014'`\u000bb\u001bU\t\u0015+J\u001f:Cq!a\u0013\u0001A\u0003%!+A\fQ%>\u001bUiU*`\u0013\u0012kEjX#Y\u0007\u0016\u0003F+S(OA!A\u0011q\n\u0001C\u0002\u0013\u0005\u0011+A\u0010Q%>\u001bUiU*`'\u000eCU)T!`\u000bb\u0003Vi\u0011+F\t~k\u0015\t\u0015)J\u001d\u001eCq!a\u0015\u0001A\u0003%!+\u0001\u0011Q%>\u001bUiU*`'\u000eCU)T!`\u000bb\u0003Vi\u0011+F\t~k\u0015\t\u0015)J\u001d\u001e\u0003\u0003\u0002CA,\u0001\t\u0007I\u0011A)\u00027A\u0013vjQ#T'~\u001b6\tS#N\u0003~+%KU(S?B\u0013VIR%Y\u0011\u001d\tY\u0006\u0001Q\u0001\nI\u000bA\u0004\u0015*P\u0007\u0016\u001b6kX*D\u0011\u0016k\u0015iX#S%>\u0013v\f\u0015*F\r&C\u0006\u0005\u0003\u0005\u0002`\u0001\u0011\r\u0011\"\u0001R\u0003a\u0001&kT\"F'N{6k\u0011%F\u001b\u0006{V\tW\"F!RKuJ\u0014\u0005\b\u0003G\u0002\u0001\u0015!\u0003S\u0003e\u0001&kT\"F'N{6k\u0011%F\u001b\u0006{V\tW\"F!RKuJ\u0014\u0011\t\u0011\u0005\u001d\u0004A1A\u0005\u0002E\u000bq\u0003V(H\u000f2+u,\u0016(N\u0003B\u0003V\tR0F\u001d\u0006\u0013E*\u0012#\t\u000f\u0005-\u0004\u0001)A\u0005%\u0006ABkT$H\u0019\u0016{VKT'B!B+EiX#O\u0003\ncU\t\u0012\u0011\t\u0011\u0005=\u0004A1A\u0005\u0002E\u000b\u0001\u0004V(H\u000f2+u,\u0016(N\u0003B\u0003V\tR0E\u0013N\u000b%\tT#E\u0011\u001d\t\u0019\b\u0001Q\u0001\nI\u000b\u0011\u0004V(H\u000f2+u,\u0016(N\u0003B\u0003V\tR0E\u0013N\u000b%\tT#EA!A\u0011q\u000f\u0001C\u0002\u0013\u0005\u0011+A\nM\u001f\u0006#uLR%M\u000b~+\u0005lQ#Q)&{e\nC\u0004\u0002|\u0001\u0001\u000b\u0011\u0002*\u0002)1{\u0015\tR0G\u00132+u,\u0012-D\u000bB#\u0016j\u0014(!\u0011!\ty\b\u0001b\u0001\n\u0003\t\u0016!\u0007'P\u0003\u0012{f)\u0013'F?\u0016C\u0006+R\"U\u000b\u0012{6\u000b\u0016*J\u001d\u001eCq!a!\u0001A\u0003%!+\u0001\u000eM\u001f\u0006#uLR%M\u000b~+\u0005\fU#D)\u0016#ul\u0015+S\u0013:;\u0005\u0005C\u0005\u0002\b\u0002\u0011\r\u0011\"\u0001\u0002\n\u00069\u0001\u000f^8mK6LXCAAF!\u0011\ti)a%\u000e\u0005\u0005=%bAAI\t\u0005!\u0011\u000eZ7m\u0013\u0011\t)*a$\u0003\u000fA#x\u000e\\3ns\"A\u0011\u0011\u0014\u0001!\u0002\u0013\tY)\u0001\u0005qi>dW-\\=!\u0001")
public class ReplTest
extends FunSpec
implements MockitoSugar,
BeforeAndAfterAll {
    private final String VERSION_VALID;
    private final String IDML_VERSION_VALID;
    private final String BUILD_DATE_VALID;
    private final String UNKNOWN_PROPERTY;
    private final String INPUT_JSON;
    private final String INPUT_IDML;
    private final String INPUT_SCHEMA;
    private final String INPUT_MODE_JSON;
    private final String INPUT_MODE_IDML;
    private final String INPUT_MODE_SCHEMA;
    private final String INPUT_MODE_INVALID;
    private final String PROCESS_INPUT_ERR_PREFIX;
    private final String PROCESS_INPUT_ERR_POSTFIX;
    private final String PROCESS_JSON_ACCEPTED;
    private final String PROCESS_JSON_ERROR_PREFIX;
    private final String PROCESS_JSON_EXCEPTION;
    private final String PROCESS_IDML_ERROR_PREFIX;
    private final String PROCESS_IDML_EXCEPTION;
    private final String PROCESS_SCHEMA_EXPECTED_MAPPING;
    private final String PROCESS_SCHEMA_ERROR_PREFIX;
    private final String PROCESS_SCHEMA_EXCEPTION;
    private final String TOGGLE_UNMAPPED_ENABLED;
    private final String TOGGLE_UNMAPPED_DISABLED;
    private final String LOAD_FILE_EXCEPTION;
    private final String LOAD_FILE_EXPECTED_STRING;
    private final Ptolemy ptolemy;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;

    public /* synthetic */ Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSpecLike.run$((FunSpecLike)this, (Option)testName, (Args)args);
    }

    public void beforeAll() {
        BeforeAndAfterAll.beforeAll$((BeforeAndAfterAll)this);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, testName, (Args)args);
    }

    public <T> T mock(ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, classTag);
    }

    public <T> T mock(Answer<?> defaultAnswer, ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, defaultAnswer, classTag);
    }

    public <T> T mock(MockSettings mockSettings, ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, (MockSettings)mockSettings, classTag);
    }

    public <T> T mock(String name, ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, (String)name, classTag);
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public void afterAll() {
        BeforeAndAfterAll.afterAll$((BeforeAndAfterAll)this);
        TerminalFactory.get().restore();
    }

    public String VERSION_VALID() {
        return this.VERSION_VALID;
    }

    public String IDML_VERSION_VALID() {
        return this.IDML_VERSION_VALID;
    }

    public String BUILD_DATE_VALID() {
        return this.BUILD_DATE_VALID;
    }

    public String UNKNOWN_PROPERTY() {
        return this.UNKNOWN_PROPERTY;
    }

    public String INPUT_JSON() {
        return this.INPUT_JSON;
    }

    public String INPUT_IDML() {
        return this.INPUT_IDML;
    }

    public String INPUT_SCHEMA() {
        return this.INPUT_SCHEMA;
    }

    public String INPUT_MODE_JSON() {
        return this.INPUT_MODE_JSON;
    }

    public String INPUT_MODE_IDML() {
        return this.INPUT_MODE_IDML;
    }

    public String INPUT_MODE_SCHEMA() {
        return this.INPUT_MODE_SCHEMA;
    }

    public String INPUT_MODE_INVALID() {
        return this.INPUT_MODE_INVALID;
    }

    public String PROCESS_INPUT_ERR_PREFIX() {
        return this.PROCESS_INPUT_ERR_PREFIX;
    }

    public String PROCESS_INPUT_ERR_POSTFIX() {
        return this.PROCESS_INPUT_ERR_POSTFIX;
    }

    public String PROCESS_JSON_ACCEPTED() {
        return this.PROCESS_JSON_ACCEPTED;
    }

    public String PROCESS_JSON_ERROR_PREFIX() {
        return this.PROCESS_JSON_ERROR_PREFIX;
    }

    public String PROCESS_JSON_EXCEPTION() {
        return this.PROCESS_JSON_EXCEPTION;
    }

    public String PROCESS_IDML_ERROR_PREFIX() {
        return this.PROCESS_IDML_ERROR_PREFIX;
    }

    public String PROCESS_IDML_EXCEPTION() {
        return this.PROCESS_IDML_EXCEPTION;
    }

    public String PROCESS_SCHEMA_EXPECTED_MAPPING() {
        return this.PROCESS_SCHEMA_EXPECTED_MAPPING;
    }

    public String PROCESS_SCHEMA_ERROR_PREFIX() {
        return this.PROCESS_SCHEMA_ERROR_PREFIX;
    }

    public String PROCESS_SCHEMA_EXCEPTION() {
        return this.PROCESS_SCHEMA_EXCEPTION;
    }

    public String TOGGLE_UNMAPPED_ENABLED() {
        return this.TOGGLE_UNMAPPED_ENABLED;
    }

    public String TOGGLE_UNMAPPED_DISABLED() {
        return this.TOGGLE_UNMAPPED_DISABLED;
    }

    public String LOAD_FILE_EXCEPTION() {
        return this.LOAD_FILE_EXCEPTION;
    }

    public String LOAD_FILE_EXPECTED_STRING() {
        return this.LOAD_FILE_EXPECTED_STRING;
    }

    public Ptolemy ptolemy() {
        return this.ptolemy;
    }

    public ReplTest() {
        MockitoSugar.$init$((MockitoSugar)this);
        BeforeAndAfterAll.$init$((BeforeAndAfterAll)this);
        this.VERSION_VALID = "1.2.3";
        this.IDML_VERSION_VALID = "4.5.10";
        this.BUILD_DATE_VALID = "201502201600";
        this.UNKNOWN_PROPERTY = "unknown";
        this.INPUT_JSON = "{}";
        this.INPUT_IDML = "test = test";
        this.INPUT_SCHEMA = "test = test";
        this.INPUT_MODE_JSON = "json";
        this.INPUT_MODE_IDML = "idml";
        this.INPUT_MODE_SCHEMA = "schema";
        this.INPUT_MODE_INVALID = "inputmode";
        this.PROCESS_INPUT_ERR_PREFIX = "Error: Unknown mode [";
        this.PROCESS_INPUT_ERR_POSTFIX = "]";
        this.PROCESS_JSON_ACCEPTED = "JSON accepted";
        this.PROCESS_JSON_ERROR_PREFIX = "Error: ";
        this.PROCESS_JSON_EXCEPTION = "json exception";
        this.PROCESS_IDML_ERROR_PREFIX = "Error: ";
        this.PROCESS_IDML_EXCEPTION = "idml exception";
        this.PROCESS_SCHEMA_EXPECTED_MAPPING = "test = test\n";
        this.PROCESS_SCHEMA_ERROR_PREFIX = "Error: ";
        this.PROCESS_SCHEMA_EXCEPTION = "schema-exception";
        this.TOGGLE_UNMAPPED_ENABLED = "Unmapped fields are enabled";
        this.TOGGLE_UNMAPPED_DISABLED = "Unmapped fields are disabled";
        this.LOAD_FILE_EXCEPTION = "Error:  (No such file or directory)";
        this.LOAD_FILE_EXPECTED_STRING = "{\n  \"test\": \"value\"\n}";
        this.describe("displaying the help text", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.it().apply("should print a string to the correct writer if called", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Repl mockRepl = (Repl)this.mock(ClassTag$.MODULE$.apply(Repl.class));
            PrintWriter mockPrintWriter = (PrintWriter)this.mock(ClassTag$.MODULE$.apply(PrintWriter.class));
            Mockito.stub((Object)mockRepl.out()).toReturn((Object)mockPrintWriter);
            mockRepl.displayHelp();
            Mockito.when((Object)BoxedUnit.UNIT).thenCallRealMethod();
            mockRepl.displayHelp();
            ((PrintWriter)Mockito.verify((Object)mockRepl.out())).println(Matchers.anyString());
        }, new Position("ReplTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62)), new Position("ReplTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
        this.ptolemy = new Ptolemy(new PtolemyConf(), new FunctionResolverService());
        this.describe("processing input based on string", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            PrintWriter mockPrintWriter = (PrintWriter)this.mock(ClassTag$.MODULE$.apply(PrintWriter.class));
            this.it().apply("should pass the input on for json processing if mode is appropriate", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Repl mockRepl = (Repl)this.mock(ClassTag$.MODULE$.apply(Repl.class));
                Mockito.stub((Object)mockRepl.out()).toReturn((Object)mockPrintWriter);
                mockRepl.processInput((Ptolemy)Matchers.any(), Matchers.anyString());
                Mockito.when((Object)BoxedUnit.UNIT).thenCallRealMethod();
                Mockito.stub((Object)mockRepl.mode()).toReturn((Object)this.INPUT_MODE_JSON());
                mockRepl.processInput(this.ptolemy(), this.INPUT_JSON());
                ((Repl)Mockito.verify((Object)mockRepl)).processJson(this.INPUT_JSON());
                ((Repl)Mockito.verify((Object)mockRepl, (VerificationMode)Mockito.never())).processIdml((Ptolemy)Matchers.any(), Matchers.anyString());
                ((Repl)Mockito.verify((Object)mockRepl, (VerificationMode)Mockito.never())).processSchema((Ptolemy)Matchers.any(), Matchers.anyString());
            }, new Position("ReplTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
            this.it().apply("should pass the input on for IDML processing if mode is appropriate", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Repl mockRepl = (Repl)this.mock(ClassTag$.MODULE$.apply(Repl.class));
                Mockito.stub((Object)mockRepl.out()).toReturn((Object)mockPrintWriter);
                mockRepl.processInput((Ptolemy)Matchers.any(), Matchers.anyString());
                Mockito.when((Object)BoxedUnit.UNIT).thenCallRealMethod();
                Mockito.stub((Object)mockRepl.mode()).toReturn((Object)this.INPUT_MODE_IDML());
                mockRepl.processInput(this.ptolemy(), this.INPUT_IDML());
                ((Repl)Mockito.verify((Object)mockRepl)).processIdml(this.ptolemy(), this.INPUT_IDML());
                ((Repl)Mockito.verify((Object)mockRepl, (VerificationMode)Mockito.never())).processJson(Matchers.anyString());
                ((Repl)Mockito.verify((Object)mockRepl, (VerificationMode)Mockito.never())).processSchema((Ptolemy)Matchers.any(), Matchers.anyString());
            }, new Position("ReplTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
            this.it().apply("should pass the input on for schema processing if mode is appropriate", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Repl mockRepl = (Repl)this.mock(ClassTag$.MODULE$.apply(Repl.class));
                Mockito.stub((Object)mockRepl.out()).toReturn((Object)mockPrintWriter);
                mockRepl.processInput((Ptolemy)Matchers.any(), Matchers.anyString());
                Mockito.when((Object)BoxedUnit.UNIT).thenCallRealMethod();
                Mockito.stub((Object)mockRepl.mode()).toReturn((Object)this.INPUT_MODE_SCHEMA());
                mockRepl.processInput(this.ptolemy(), this.INPUT_SCHEMA());
                ((Repl)Mockito.verify((Object)mockRepl)).processSchema(this.ptolemy(), this.INPUT_SCHEMA());
                ((Repl)Mockito.verify((Object)mockRepl, (VerificationMode)Mockito.never())).processIdml((Ptolemy)Matchers.any(), Matchers.anyString());
                ((Repl)Mockito.verify((Object)mockRepl, (VerificationMode)Mockito.never())).processJson(Matchers.anyString());
            }, new Position("ReplTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
            this.it().apply("should print out an error if the mode does not match", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Repl mockRepl = (Repl)this.mock(ClassTag$.MODULE$.apply(Repl.class));
                Mockito.stub((Object)mockRepl.out()).toReturn((Object)mockPrintWriter);
                mockRepl.processInput((Ptolemy)Matchers.any(), Matchers.anyString());
                Mockito.when((Object)BoxedUnit.UNIT).thenCallRealMethod();
                Mockito.stub((Object)mockRepl.mode()).toReturn((Object)this.INPUT_MODE_INVALID());
                mockRepl.processInput(this.ptolemy(), this.INPUT_JSON());
                ((PrintWriter)Mockito.verify((Object)mockPrintWriter)).println(new StringBuilder(0).append(this.PROCESS_INPUT_ERR_PREFIX()).append(this.INPUT_MODE_INVALID()).append(this.PROCESS_INPUT_ERR_POSTFIX()).toString());
            }, new Position("ReplTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
        }, new Position("ReplTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        this.describe("processing of json input", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestRepl repl = new TestRepl();
            this.it().apply("should attempt to parse the input, print status and change mode to IDML if input is valid", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
                repl.processJson(this.INPUT_JSON());
                PObject $org_scalatest_assert_macro_left = (PObject)repl.doc().get();
                PtolemyObject $org_scalatest_assert_macro_right = (PtolemyObject)PtolemyJson$.MODULE$.parse(this.INPUT_JSON());
                PObject pObject = $org_scalatest_assert_macro_left;
                PtolemyObject ptolemyObject = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(pObject != null ? !pObject.equals(ptolemyObject) : ptolemyObject != null), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReplTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
                ((PrintWriter)Mockito.verify((Object)repl.out())).println(this.PROCESS_JSON_ACCEPTED());
                String $org_scalatest_assert_macro_left2 = repl.mode();
                String $org_scalatest_assert_macro_right2 = this.INPUT_MODE_IDML();
                String string = $org_scalatest_assert_macro_left2;
                String string2 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ReplTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
            }, new Position("ReplTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
            this.it().apply("should print an error if an exception is thrown whilst processing", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                repl.out().println(this.PROCESS_JSON_ACCEPTED());
                Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{new RuntimeException(this.PROCESS_JSON_EXCEPTION())});
                repl.processJson(this.INPUT_JSON());
                ((PrintWriter)Mockito.verify((Object)repl.out())).println(new StringBuilder(0).append(this.PROCESS_JSON_ERROR_PREFIX()).append(this.PROCESS_JSON_EXCEPTION()).toString());
            }, new Position("ReplTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
        }, new Position("ReplTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
        this.describe("processing of idml input", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestRepl repl = new TestRepl();
            this.it().apply("should attempt to parse and print the input if valid", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                repl.processJson(this.INPUT_JSON());
                repl.processIdml(this.ptolemy(), this.INPUT_IDML());
                PtolemyMapping mapping = this.ptolemy().fromString(this.INPUT_IDML());
                String expectedJson = PtolemyJson$.MODULE$.pretty((PtolemyValue)mapping.run((PtolemyValue)repl.doc().get()));
                ((PrintWriter)Mockito.verify((Object)repl.out())).println(expectedJson);
            }, new Position("ReplTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
            this.it().apply("should print an error if an exception is thrown whilst processing", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Ptolemy ptolemy = new Ptolemy(new PtolemyConf());
                PtolemyMapping mapping = ptolemy.fromString(this.INPUT_IDML());
                String expectedJson = PtolemyJson$.MODULE$.pretty((PtolemyValue)mapping.run((PtolemyValue)repl.doc().get()));
                repl.out().println(expectedJson);
                Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{new RuntimeException(this.PROCESS_IDML_EXCEPTION())});
                repl.processJson(this.INPUT_JSON());
                repl.processIdml(ptolemy, this.INPUT_IDML());
                ((PrintWriter)Mockito.verify((Object)repl.out())).println(new StringBuilder(0).append(this.PROCESS_IDML_ERROR_PREFIX()).append(this.PROCESS_IDML_EXCEPTION()).toString());
            }, new Position("ReplTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
        }, new Position("ReplTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
        this.describe("processing of schema input", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.it().apply("should construct a mapping string and attempt to parse then print the input if valid", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Ptolemy ptolemy = new Ptolemy(new PtolemyConf());
                PtolemyMapping mapping = ptolemy.fromString(new StringBuilder(0).append(this.PROCESS_SCHEMA_EXPECTED_MAPPING()).append(this.INPUT_SCHEMA()).toString());
                TestRepl repl = new TestRepl();
                repl.processJson(this.INPUT_JSON());
                String expectedJson = PtolemyJson$.MODULE$.pretty((PtolemyValue)mapping.run((PtolemyValue)repl.doc().get()));
                repl.processSchema(ptolemy, this.INPUT_SCHEMA());
                ((PrintWriter)Mockito.verify((Object)repl.out())).println(this.PROCESS_JSON_ACCEPTED());
                ((PrintWriter)Mockito.verify((Object)repl.out())).println(expectedJson);
            }, new Position("ReplTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
            this.it().apply("should print an error if an exception is thrown whilst processing", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Ptolemy ptolemy = new Ptolemy(new PtolemyConf());
                PtolemyMapping mapping = ptolemy.fromString(new StringBuilder(0).append(this.PROCESS_SCHEMA_EXPECTED_MAPPING()).append(this.INPUT_SCHEMA()).toString());
                TestRepl repl = new TestRepl();
                repl.processJson(this.INPUT_JSON());
                String output = PtolemyJson$.MODULE$.pretty((PtolemyValue)mapping.run((PtolemyValue)repl.doc().get()));
                repl.out().println(output);
                Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{new RuntimeException(this.PROCESS_SCHEMA_EXCEPTION())});
                repl.processSchema(ptolemy, this.INPUT_SCHEMA());
                ((PrintWriter)Mockito.verify((Object)repl.out())).println(new StringBuilder(0).append(this.PROCESS_SCHEMA_ERROR_PREFIX()).append(this.PROCESS_SCHEMA_EXCEPTION()).toString());
            }, new Position("ReplTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
        }, new Position("ReplTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
        this.describe("loading of a file", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestRepl repl = new TestRepl();
            this.it().apply("should return a string delimited with new lines containing the file's contents", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
                String ret;
                String string = ret = repl.loadFile("repl/src/test/resources/testfile.json");
                String string2 = "";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    ret = repl.loadFile("src/test/resources/testfile.json");
                }
                String $org_scalatest_assert_macro_left = ret;
                String $org_scalatest_assert_macro_right = this.LOAD_FILE_EXPECTED_STRING();
                String string3 = $org_scalatest_assert_macro_left;
                String string4 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
                return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReplTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 226));
            }, new Position("ReplTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221));
            this.it().apply("should print an error if an exception is thrown whilst processing", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                repl.loadFile("");
                ((PrintWriter)Mockito.verify((Object)repl.out())).println(this.LOAD_FILE_EXCEPTION());
            }, new Position("ReplTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229));
        }, new Position("ReplTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
    }

    public class TestRepl
    extends Repl {
        private final PrintWriter out;
        private final String IDML_VERSION;
        private final String BUILD_DATE;

        public PrintWriter out() {
            return this.out;
        }

        public String IDML_VERSION() {
            return this.IDML_VERSION;
        }

        public String BUILD_DATE() {
            return this.BUILD_DATE;
        }

        public /* synthetic */ ReplTest io$idmlrepl$ReplTest$TestRepl$$$outer() {
            return ReplTest.this;
        }

        public TestRepl() {
            if (ReplTest.this == null) {
                throw null;
            }
            this.out = (PrintWriter)ReplTest.this.mock(ClassTag$.MODULE$.apply(PrintWriter.class));
            this.IDML_VERSION = "";
            this.BUILD_DATE = "";
        }
    }

    public interface mock {
    }
}

