/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util.collections;

import io.ktor.util.collections.ConcurrentMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0000\n\u0000\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003\u00a8\u0006\u0004"}, d2={"ConcurrentSet", "", "Key", "", "ktor-utils"})
public final class ConcurrentSetKt {
    @NotNull
    public static final <Key> Set<Key> ConcurrentSet() {
        return new Set<Key>(){
            @NotNull
            private final ConcurrentMap<Key, Unit> delegate;
            {
                this.delegate = new ConcurrentMap<Key, Value>(0, 1, null);
            }

            public boolean add(@NotNull Key element) {
                Intrinsics.checkNotNullParameter(element, (String)"element");
                if (this.delegate.containsKey(element)) {
                    return false;
                }
                ((Map)this.delegate).put(element, Unit.INSTANCE);
                return true;
            }

            public boolean addAll(@NotNull Collection<? extends Key> elements) {
                boolean bl;
                block3: {
                    Intrinsics.checkNotNullParameter(elements, (String)"elements");
                    Iterable $this$all$iv = elements;
                    boolean $i$f$all = false;
                    if (((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        Iterator<T> iterator2 = $this$all$iv.iterator();
                        while (iterator2.hasNext()) {
                            T element$iv;
                            T it = element$iv = iterator2.next();
                            boolean bl2 = false;
                            if (this.add((Key)it)) continue;
                            bl = false;
                            break block3;
                        }
                        bl = true;
                    }
                }
                return bl;
            }

            public void clear() {
                this.delegate.clear();
            }

            @NotNull
            public Iterator<Key> iterator() {
                return this.delegate.keySet().iterator();
            }

            public boolean remove(@Nullable Object element) {
                if (element == null) {
                    return false;
                }
                return this.delegate.remove(element) != null;
            }

            public boolean removeAll(@NotNull Collection<? extends Object> elements) {
                boolean bl;
                block3: {
                    Intrinsics.checkNotNullParameter(elements, (String)"elements");
                    Iterable $this$all$iv = elements;
                    boolean $i$f$all = false;
                    if (((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        Iterator<T> iterator2 = $this$all$iv.iterator();
                        while (iterator2.hasNext()) {
                            T element$iv;
                            T it = element$iv = iterator2.next();
                            boolean bl2 = false;
                            if (this.remove(it)) continue;
                            bl = false;
                            break block3;
                        }
                        bl = true;
                    }
                }
                return bl;
            }

            public boolean retainAll(@NotNull Collection<? extends Object> elements) {
                Intrinsics.checkNotNullParameter(elements, (String)"elements");
                Set removeList = new LinkedHashSet<E>();
                for (Key key : this.delegate.keySet()) {
                    if (elements.contains(key)) continue;
                    removeList.add(key);
                }
                return this.removeAll(removeList);
            }

            public int getSize() {
                return this.delegate.size();
            }

            public boolean contains(@Nullable Object element) {
                if (element == null) {
                    return false;
                }
                return this.delegate.containsKey(element);
            }

            public boolean containsAll(@NotNull Collection<? extends Object> elements) {
                Intrinsics.checkNotNullParameter(elements, (String)"elements");
                return elements.containsAll((Collection)this.delegate.keySet());
            }

            public boolean isEmpty() {
                return this.delegate.isEmpty();
            }

            public <T> T[] toArray(T[] array) {
                Intrinsics.checkNotNullParameter(array, (String)"array");
                return CollectionToArray.toArray((Collection)this, (Object[])array);
            }

            public Object[] toArray() {
                return CollectionToArray.toArray((Collection)this);
            }
        };
    }
}

