/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util.collections;

import io.ktor.util.InternalAPI;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.atomicfu.AtomicFU;
import kotlinx.atomicfu.AtomicRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalAPI
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0004J6\u0010\b\u001a\u00028\u00012\u0006\u0010\t\u001a\u00028\u00002!\u0010\n\u001a\u001d\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00028\u00010\u000b\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u000f\u001a\u0004\u0018\u00018\u00012\u0006\u0010\t\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\u0010J\u001d\u0010\u0011\u001a\u0004\u0018\u00018\u00012\u0006\u0010\t\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0013J\u0015\u0010\u0014\u001a\u0004\u0018\u00018\u00012\u0006\u0010\t\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0010J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00028\u0001H\u0086\u0002\u00a2\u0006\u0002\u0010\u0017R \u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/ktor/util/collections/CopyOnWriteHashMap;", "K", "", "V", "()V", "current", "Lkotlinx/atomicfu/AtomicRef;", "", "computeIfAbsent", "key", "producer", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "put", "value", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "remove", "set", "", "(Ljava/lang/Object;Ljava/lang/Object;)V", "ktor-utils"})
public final class CopyOnWriteHashMap<K, V> {
    @NotNull
    private final AtomicRef<Map<K, V>> current = AtomicFU.atomic((Object)MapsKt.emptyMap());

    @Nullable
    public final V put(@NotNull K key, @NotNull V value) {
        Object replaced;
        HashMap<K, V> copy;
        Map old;
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        do {
            if ((old = (Map)this.current.getValue()).get(key) == value) {
                return value;
            }
            copy = new HashMap<K, V>(old);
            replaced = copy.put(key, value);
        } while (!this.current.compareAndSet((Object)old, copy));
        return replaced;
    }

    @Nullable
    public final V get(@NotNull K key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return ((Map)this.current.getValue()).get(key);
    }

    public final void set(@NotNull K key, @NotNull V value) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.put(key, value);
    }

    @Nullable
    public final V remove(@NotNull K key) {
        Object removed;
        HashMap copy;
        Map old;
        Intrinsics.checkNotNullParameter(key, (String)"key");
        do {
            if ((old = (Map)this.current.getValue()).get(key) == null) {
                return null;
            }
            copy = new HashMap(old);
            removed = copy.remove(key);
        } while (!this.current.compareAndSet((Object)old, copy));
        return removed;
    }

    @NotNull
    public final V computeIfAbsent(@NotNull K key, @NotNull Function1<? super K, ? extends V> producer) {
        Object newValue;
        HashMap copy;
        Map old;
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(producer, (String)"producer");
        do {
            Object v;
            if ((v = (old = (Map)this.current.getValue()).get(key)) != null) {
                Object it = v;
                boolean bl = false;
                return it;
            }
            copy = new HashMap(old);
            newValue = producer.invoke(key);
            ((Map)copy).put(key, newValue);
        } while (!this.current.compareAndSet((Object)old, copy));
        return (V)newValue;
    }
}

