/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.kafka;

import io.micrometer.core.annotation.Incubating;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.lang.NonNullApi;
import io.micrometer.core.lang.NonNullFields;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;

@NonNullApi
@NonNullFields
@Incubating(since="1.4.0")
class KafkaMetrics
implements MeterBinder {
    static final String METRIC_NAME_PREFIX = "kafka.";
    static final String METRIC_GROUP_APP_INFO = "app-info";
    static final String METRIC_GROUP_METRICS_COUNT = "kafka-metrics-count";
    static final String VERSION_METRIC_NAME = "version";
    static final String START_TIME_METRIC_NAME = "start-time-ms";
    private final Supplier<Map<MetricName, ? extends Metric>> metricsSupplier;
    private final Iterable<Tag> extraTags;
    private volatile Set<MetricName> currentMeters = new HashSet<MetricName>();
    private String kafkaVersion = "unknown";

    KafkaMetrics(Supplier<Map<MetricName, ? extends Metric>> metricsSupplier) {
        this(metricsSupplier, Collections.emptyList());
    }

    KafkaMetrics(Supplier<Map<MetricName, ? extends Metric>> metricsSupplier, Iterable<Tag> extraTags) {
        this.metricsSupplier = metricsSupplier;
        this.extraTags = extraTags;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        Map<MetricName, ? extends Metric> metrics = this.metricsSupplier.get();
        Metric startTime = null;
        for (Map.Entry<MetricName, ? extends Metric> entry : metrics.entrySet()) {
            MetricName name = entry.getKey();
            if (!METRIC_GROUP_APP_INFO.equals(name.group())) continue;
            if (VERSION_METRIC_NAME.equals(name.name())) {
                this.kafkaVersion = (String)entry.getValue().metricValue();
                continue;
            }
            if (!START_TIME_METRIC_NAME.equals(name.name())) continue;
            startTime = entry.getValue();
        }
        if (startTime != null) {
            this.bindMeter(registry, startTime, this.meterName(startTime), this.meterTags(startTime));
        }
        this.checkAndBindMetrics(registry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkAndBindMetrics(MeterRegistry registry) {
        Map<MetricName, ? extends Metric> metrics = this.metricsSupplier.get();
        if (!this.currentMeters.equals(metrics.keySet())) {
            KafkaMetrics kafkaMetrics = this;
            synchronized (kafkaMetrics) {
                if (!this.currentMeters.equals(metrics.keySet())) {
                    this.currentMeters = new HashSet<MetricName>(metrics.keySet());
                    metrics.forEach((name, metric) -> {
                        if (!(metric.metricValue() instanceof Number)) {
                            return;
                        }
                        if (METRIC_GROUP_APP_INFO.equals(name.group())) {
                            return;
                        }
                        if (METRIC_GROUP_METRICS_COUNT.equals(name.group())) {
                            return;
                        }
                        String meterName = this.meterName((Metric)metric);
                        List<Tag> meterTags = this.meterTags((Metric)metric);
                        boolean hasLessTags = false;
                        for (Meter other : registry.find(meterName).meters()) {
                            List<Tag> tags = other.getId().getTags();
                            if (tags.size() < meterTags.size()) {
                                registry.remove(other);
                                continue;
                            }
                            if (tags.size() == meterTags.size()) {
                                if (!tags.equals(meterTags)) break;
                                return;
                            }
                            hasLessTags = true;
                        }
                        if (hasLessTags) {
                            return;
                        }
                        this.bindMeter(registry, (Metric)metric, meterName, (Iterable<Tag>)meterTags);
                    });
                }
            }
        }
    }

    private void bindMeter(MeterRegistry registry, Metric metric, String name, Iterable<Tag> tags) {
        if (name.endsWith("total") || name.endsWith("count")) {
            this.registerCounter(registry, metric, name, tags);
        } else {
            this.registerGauge(registry, metric, name, tags);
        }
    }

    private void registerGauge(MeterRegistry registry, Metric metric, String name, Iterable<Tag> tags) {
        Gauge.builder(name, metric, this.toMetricValue(registry)).tags(tags).description(metric.metricName().description()).register(registry);
    }

    private void registerCounter(MeterRegistry registry, Metric metric, String name, Iterable<Tag> tags) {
        FunctionCounter.builder(name, metric, this.toMetricValue(registry)).tags(tags).description(metric.metricName().description()).register(registry);
    }

    private ToDoubleFunction<Metric> toMetricValue(MeterRegistry registry) {
        return metric -> {
            this.checkAndBindMetrics(registry);
            return ((Number)metric.metricValue()).doubleValue();
        };
    }

    private List<Tag> meterTags(Metric metric) {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        metric.metricName().tags().forEach((key, value) -> tags.add(Tag.of(key, value)));
        tags.add(Tag.of("kafka-version", this.kafkaVersion));
        this.extraTags.forEach(tags::add);
        return tags;
    }

    private String meterName(Metric metric) {
        String name = METRIC_NAME_PREFIX + metric.metricName().group() + "." + metric.metricName().name();
        return name.replaceAll("-metrics", "").replaceAll("-", ".");
    }
}

