/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.quic;

import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.util.KeyManagerFactoryWrapper;
import io.netty.handler.ssl.util.TrustManagerFactoryWrapper;
import io.netty.incubator.codec.quic.BoringSSLKeylog;
import io.netty.incubator.codec.quic.BoringSSLLoggingKeylog;
import io.netty.incubator.codec.quic.QuicSslContext;
import io.netty.incubator.codec.quic.QuicheQuicSslContext;
import io.netty.util.Mapping;
import io.netty.util.internal.ObjectUtil;
import java.io.File;
import java.net.Socket;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;

public final class QuicSslContextBuilder {
    private static final X509ExtendedKeyManager SNI_KEYMANAGER = new X509ExtendedKeyManager(){
        private final X509Certificate[] emptyCerts = new X509Certificate[0];
        private final String[] emptyStrings = new String[0];

        @Override
        public String[] getClientAliases(String keyType, Principal[] issuers) {
            return this.emptyStrings;
        }

        @Override
        public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
            return null;
        }

        @Override
        public String[] getServerAliases(String keyType, Principal[] issuers) {
            return this.emptyStrings;
        }

        @Override
        public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
            return null;
        }

        @Override
        public X509Certificate[] getCertificateChain(String alias) {
            return this.emptyCerts;
        }

        @Override
        public PrivateKey getPrivateKey(String alias) {
            return null;
        }
    };
    private final boolean forServer;
    private TrustManagerFactory trustManagerFactory;
    private String keyPassword;
    private KeyManagerFactory keyManagerFactory;
    private long sessionCacheSize = 20480L;
    private long sessionTimeout = 300L;
    private ClientAuth clientAuth = ClientAuth.NONE;
    private String[] applicationProtocols;
    private Boolean earlyData;
    private BoringSSLKeylog keylog;
    private Mapping<? super String, ? extends QuicSslContext> mapping;

    public static QuicSslContextBuilder forClient() {
        return new QuicSslContextBuilder(false);
    }

    public static QuicSslContextBuilder forServer(File keyFile, String keyPassword, File certChainFile) {
        return new QuicSslContextBuilder(true).keyManager(keyFile, keyPassword, certChainFile);
    }

    public static QuicSslContextBuilder forServer(PrivateKey key, String keyPassword, X509Certificate ... certChain) {
        return new QuicSslContextBuilder(true).keyManager(key, keyPassword, certChain);
    }

    public static QuicSslContextBuilder forServer(KeyManagerFactory keyManagerFactory, String password) {
        return new QuicSslContextBuilder(true).keyManager(keyManagerFactory, password);
    }

    public static QuicSslContextBuilder forServer(KeyManager keyManager, String keyPassword) {
        return new QuicSslContextBuilder(true).keyManager(keyManager, keyPassword);
    }

    public static QuicSslContext buildForServerWithSni(Mapping<? super String, ? extends QuicSslContext> mapping) {
        return QuicSslContextBuilder.forServer(SNI_KEYMANAGER, null).sni(mapping).build();
    }

    private QuicSslContextBuilder(boolean forServer) {
        this.forServer = forServer;
    }

    private QuicSslContextBuilder sni(Mapping<? super String, ? extends QuicSslContext> mapping) {
        this.mapping = (Mapping)ObjectUtil.checkNotNull(mapping, (String)"mapping");
        return this;
    }

    public QuicSslContextBuilder earlyData(boolean enabled) {
        this.earlyData = enabled;
        return this;
    }

    public QuicSslContextBuilder keylog(boolean enabled) {
        this.keylog(enabled ? BoringSSLLoggingKeylog.INSTANCE : null);
        return this;
    }

    public QuicSslContextBuilder keylog(BoringSSLKeylog keylog) {
        this.keylog = keylog;
        return this;
    }

    public QuicSslContextBuilder trustManager(File trustCertCollectionFile) {
        try {
            return this.trustManager(QuicheQuicSslContext.toX509Certificates0(trustCertCollectionFile));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("File does not contain valid certificates: " + trustCertCollectionFile, e);
        }
    }

    public QuicSslContextBuilder trustManager(X509Certificate ... trustCertCollection) {
        try {
            return this.trustManager(QuicheQuicSslContext.buildTrustManagerFactory0(trustCertCollection));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public QuicSslContextBuilder trustManager(TrustManagerFactory trustManagerFactory) {
        this.trustManagerFactory = trustManagerFactory;
        return this;
    }

    public QuicSslContextBuilder trustManager(TrustManager trustManager) {
        return this.trustManager((TrustManagerFactory)new TrustManagerFactoryWrapper(trustManager));
    }

    public QuicSslContextBuilder keyManager(File keyFile, String keyPassword, File keyCertChainFile) {
        PrivateKey key;
        X509Certificate[] keyCertChain;
        try {
            keyCertChain = QuicheQuicSslContext.toX509Certificates0(keyCertChainFile);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("File does not contain valid certificates: " + keyCertChainFile, e);
        }
        try {
            key = QuicheQuicSslContext.toPrivateKey0(keyFile, keyPassword);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("File does not contain valid private key: " + keyFile, e);
        }
        return this.keyManager(key, keyPassword, keyCertChain);
    }

    public QuicSslContextBuilder keyManager(PrivateKey key, String keyPassword, X509Certificate ... certChain) {
        try {
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(null);
            char[] pass = keyPassword == null ? new char[]{} : keyPassword.toCharArray();
            ks.setKeyEntry("alias", key, pass, certChain);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(ks, pass);
            return this.keyManager(keyManagerFactory, keyPassword);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public QuicSslContextBuilder keyManager(KeyManagerFactory keyManagerFactory, String keyPassword) {
        this.keyPassword = keyPassword;
        this.keyManagerFactory = keyManagerFactory;
        return this;
    }

    public QuicSslContextBuilder keyManager(KeyManager keyManager, String password) {
        return this.keyManager((KeyManagerFactory)new KeyManagerFactoryWrapper(keyManager), password);
    }

    public QuicSslContextBuilder applicationProtocols(String ... applicationProtocols) {
        this.applicationProtocols = applicationProtocols;
        return this;
    }

    public QuicSslContextBuilder sessionCacheSize(long sessionCacheSize) {
        this.sessionCacheSize = sessionCacheSize;
        return this;
    }

    public QuicSslContextBuilder sessionTimeout(long sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
        return this;
    }

    public QuicSslContextBuilder clientAuth(ClientAuth clientAuth) {
        if (!this.forServer) {
            throw new UnsupportedOperationException("Only supported for server");
        }
        this.clientAuth = (ClientAuth)ObjectUtil.checkNotNull((Object)clientAuth, (String)"clientAuth");
        return this;
    }

    public QuicSslContext build() {
        if (this.forServer) {
            return new QuicheQuicSslContext(true, this.sessionTimeout, this.sessionCacheSize, this.clientAuth, this.trustManagerFactory, this.keyManagerFactory, this.keyPassword, this.mapping, this.earlyData, this.keylog, this.applicationProtocols);
        }
        return new QuicheQuicSslContext(false, this.sessionTimeout, this.sessionCacheSize, this.clientAuth, this.trustManagerFactory, this.keyManagerFactory, this.keyPassword, this.mapping, this.earlyData, this.keylog, this.applicationProtocols);
    }
}

