/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.context.propagation;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nullable;

public final class DefaultContextPropagators
implements ContextPropagators {
    private final TextMapPropagator textMapPropagator;

    @Override
    public TextMapPropagator getTextMapPropagator() {
        return this.textMapPropagator;
    }

    public static Builder builder() {
        return new Builder();
    }

    private DefaultContextPropagators(TextMapPropagator textMapPropagator) {
        this.textMapPropagator = textMapPropagator;
    }

    private static final class NoopTextMapPropagator
    implements TextMapPropagator {
        private static final NoopTextMapPropagator INSTANCE = new NoopTextMapPropagator();

        private NoopTextMapPropagator() {
        }

        @Override
        public List<String> fields() {
            return Collections.emptyList();
        }

        @Override
        public <C> void inject(Context context, @Nullable C carrier, TextMapPropagator.Setter<C> setter) {
        }

        @Override
        public <C> Context extract(Context context, @Nullable C carrier, TextMapPropagator.Getter<C> getter) {
            return context;
        }
    }

    private static final class MultiTextMapPropagator
    implements TextMapPropagator {
        private final TextMapPropagator[] textPropagators;
        private final List<String> allFields;

        private MultiTextMapPropagator(List<TextMapPropagator> textPropagators) {
            this.textPropagators = new TextMapPropagator[textPropagators.size()];
            textPropagators.toArray(this.textPropagators);
            this.allFields = Collections.unmodifiableList(MultiTextMapPropagator.getAllFields(this.textPropagators));
        }

        @Override
        public List<String> fields() {
            return this.allFields;
        }

        private static List<String> getAllFields(TextMapPropagator[] textPropagators) {
            LinkedHashSet<String> fields = new LinkedHashSet<String>();
            for (int i = 0; i < textPropagators.length; ++i) {
                fields.addAll(textPropagators[i].fields());
            }
            return new ArrayList<String>(fields);
        }

        @Override
        public <C> void inject(Context context, @Nullable C carrier, TextMapPropagator.Setter<C> setter) {
            for (int i = 0; i < this.textPropagators.length; ++i) {
                this.textPropagators[i].inject(context, carrier, setter);
            }
        }

        @Override
        public <C> Context extract(Context context, @Nullable C carrier, TextMapPropagator.Getter<C> getter) {
            for (int i = 0; i < this.textPropagators.length; ++i) {
                context = this.textPropagators[i].extract(context, carrier, getter);
            }
            return context;
        }
    }

    public static final class Builder {
        List<TextMapPropagator> textPropagators = new ArrayList<TextMapPropagator>();

        public Builder addTextMapPropagator(TextMapPropagator textMapPropagator) {
            if (textMapPropagator == null) {
                throw new NullPointerException("textMapPropagator");
            }
            this.textPropagators.add(textMapPropagator);
            return this;
        }

        public ContextPropagators build() {
            if (this.textPropagators.isEmpty()) {
                return new DefaultContextPropagators(NoopTextMapPropagator.INSTANCE);
            }
            return new DefaultContextPropagators(new MultiTextMapPropagator(this.textPropagators));
        }
    }
}

