/*
 * Decompiled with CFR 0.152.
 */
package io.parallec.core;

import akka.actor.ActorRef;
import com.ning.http.client.AsyncHttpClient;
import io.parallec.core.ParallecResponseHandler;
import io.parallec.core.RequestProtocol;
import io.parallec.core.actor.message.CancelTaskOnHostRequest;
import io.parallec.core.actor.message.NodeReqResponse;
import io.parallec.core.actor.message.type.ExecutionManagerMsgType;
import io.parallec.core.bean.HttpMeta;
import io.parallec.core.bean.SetAndCount;
import io.parallec.core.bean.StrStrMap;
import io.parallec.core.bean.TargetHostMeta;
import io.parallec.core.bean.ping.PingMeta;
import io.parallec.core.bean.ssh.SshMeta;
import io.parallec.core.bean.tcp.TcpMeta;
import io.parallec.core.bean.udp.UdpMeta;
import io.parallec.core.config.ParallecGlobalConfig;
import io.parallec.core.config.ParallelTaskConfig;
import io.parallec.core.exception.ParallelTaskInvalidException;
import io.parallec.core.task.ParallelTaskBean;
import io.parallec.core.task.ParallelTaskManager;
import io.parallec.core.task.ParallelTaskState;
import io.parallec.core.task.RequestReplacementType;
import io.parallec.core.task.TaskErrorMeta;
import io.parallec.core.util.PcDateUtils;
import io.parallec.core.util.PcStringUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelTask {
    private static Logger logger = LoggerFactory.getLogger(ParallelTask.class);
    private ParallelTaskConfig config = new ParallelTaskConfig();
    private long submitTime;
    private long executeStartTime;
    private long executionEndTime;
    private double durationSec;
    private int requestNum;
    private int requestNumActual;
    private volatile int responsedNum = 0;
    private final List<TaskErrorMeta> taskErrorMetas = new ArrayList<TaskErrorMeta>();
    private Map<String, Object> responseContext = new HashMap<String, Object>();
    private ParallelTaskState state = ParallelTaskState.WAITING;
    private String taskId;
    private ParallecResponseHandler handler;
    private final Map<String, LinkedHashSet<String>> aggregateResultMap = new ConcurrentHashMap<String, LinkedHashSet<String>>();
    private Map<String, NodeReqResponse> parallelTaskResult = new ConcurrentHashMap<String, NodeReqResponse>();
    private HttpMeta httpMeta;
    private TargetHostMeta targetHostMeta;
    private SshMeta sshMeta;
    private TcpMeta tcpMeta;
    private UdpMeta udpMeta;
    private PingMeta pingMeta;
    public ActorRef executionManager = null;
    private final Map<String, StrStrMap> replacementVarMapNodeSpecific = new ConcurrentHashMap<String, StrStrMap>();
    private final Map<String, String> replacementVarMap = new ConcurrentHashMap<String, String>();
    private RequestReplacementType requestReplacementType = RequestReplacementType.NO_REPLACEMENT;
    private RequestProtocol requestProtocol;
    private int concurrency;

    public ParallelTask() {
        this.setTaskId(this.generateTaskId());
        this.responsedNum = 0;
        this.requestNum = 0;
        this.state = ParallelTaskState.WAITING;
        this.config = new ParallelTaskConfig();
    }

    public ParallelTask(RequestProtocol requestProtocol, int concurrency, HttpMeta httpMeta, TargetHostMeta targetHostMeta, SshMeta sshMeta, TcpMeta tcpMeta, UdpMeta udpMeta, PingMeta pingMeta, ParallecResponseHandler handler, Map<String, Object> responseContext, Map<String, StrStrMap> replacementVarMapNodeSpecific, Map<String, String> replacementVarMap, RequestReplacementType requestReplacementType, ParallelTaskConfig config) {
        this.requestProtocol = requestProtocol;
        this.concurrency = concurrency;
        this.targetHostMeta = targetHostMeta;
        this.taskId = this.generateTaskId();
        this.requestNumActual = this.requestNum = targetHostMeta.getHosts().size();
        this.httpMeta = httpMeta;
        this.tcpMeta = tcpMeta;
        this.udpMeta = udpMeta;
        this.sshMeta = sshMeta;
        this.pingMeta = pingMeta;
        this.handler = handler;
        this.responsedNum = 0;
        this.state = ParallelTaskState.WAITING;
        if (responseContext != null) {
            this.responseContext = responseContext;
        }
        this.replacementVarMapNodeSpecific.putAll(replacementVarMapNodeSpecific);
        this.replacementVarMap.putAll(replacementVarMap);
        this.requestReplacementType = requestReplacementType;
        this.config = config;
    }

    public boolean cancelOnTargetHosts(List<String> targetHosts) {
        boolean success = false;
        try {
            switch (this.state) {
                case IN_PROGRESS: {
                    if (this.executionManager != null && !this.executionManager.isTerminated()) {
                        this.executionManager.tell((Object)new CancelTaskOnHostRequest(targetHosts), this.executionManager);
                        logger.info("asked task to stop from running on target hosts with count {}...", (Object)targetHosts.size());
                    } else {
                        logger.info("manager already killed or not exist.. NO OP");
                    }
                    success = true;
                    break;
                }
                case COMPLETED_WITHOUT_ERROR: 
                case COMPLETED_WITH_ERROR: 
                case WAITING: {
                    logger.info("will NO OP for cancelOnTargetHost as it is not in IN_PROGRESS state");
                    success = true;
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error("cancel task {} on hosts with count {} error with exception details ", new Object[]{this.getTaskId(), targetHosts.size(), e});
        }
        return success;
    }

    public boolean cancel(boolean sync) {
        boolean success = false;
        try {
            switch (this.state) {
                case WAITING: {
                    ParallelTaskManager.getInstance().removeTaskFromWaitQ(this);
                    this.state = ParallelTaskState.COMPLETED_WITHOUT_ERROR;
                    success = true;
                    break;
                }
                case IN_PROGRESS: {
                    if (this.executionManager != null && !this.executionManager.isTerminated()) {
                        this.executionManager.tell((Object)ExecutionManagerMsgType.CANCEL, this.executionManager);
                        logger.info("Asked parallel task {} to stop from running...", (Object)this.taskId);
                        if (sync) {
                            logger.info("Run cancel in SYNC mode... waiting for task to finish...");
                            while (!this.isCompleted()) {
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (InterruptedException e) {
                                    logger.error(" task {} interrupted ", (Object)this.taskId);
                                }
                            }
                            logger.info("Task completed! Cancellation is completed.");
                        } else {
                            logger.info("Run cancel in ASYNC mode... will now return...");
                        }
                    } else {
                        logger.info("manager already killed or not exist..");
                    }
                    this.state = ParallelTaskState.COMPLETED_WITH_ERROR;
                    success = true;
                    break;
                }
                case COMPLETED_WITHOUT_ERROR: 
                case COMPLETED_WITH_ERROR: {
                    logger.info("task are already in completed state..no operation...");
                    success = true;
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error("cancel task {} error with exception details ", (Object)this.getTaskId(), (Object)e);
        }
        return success;
    }

    public int capacityUsed() {
        return Math.min(this.requestNum, this.getConcurrency());
    }

    public boolean validateWithFillDefault() throws ParallelTaskInvalidException {
        if (this.targetHostMeta.getHosts().isEmpty()) {
            throw new ParallelTaskInvalidException("Empty targetHosts! Please set target hosts and try again...return..");
        }
        if (this.requestProtocol == null) {
            this.requestProtocol = RequestProtocol.HTTP;
            logger.info("USE DEFAULT HTTP PROTOCOL: Missing Protocol HTTP/HTTPS. SET protocol as default HTTP");
        }
        if (this.getConcurrency() <= 0 || this.getConcurrency() > ParallecGlobalConfig.maxCapacity) {
            logger.info("USE DEFAULT CONCURRENCY: User did not specify max concurrency or its out of max allowed capacity: " + ParallecGlobalConfig.concurrencyDefault);
            this.setConcurrency(ParallecGlobalConfig.concurrencyDefault);
        }
        if (this.config == null) {
            logger.info("USE DEFAULT CONFIG: User did not specify config for task/actor timeout etc. ");
            this.config = new ParallelTaskConfig();
        }
        if (this.requestProtocol == RequestProtocol.SSH) {
            this.sshMeta.validation();
            if (this.getConcurrency() > ParallecGlobalConfig.concurrencySshLimit) {
                logger.info("SSH CONCURRENCY LIMIT is lower. Apply value as: " + ParallecGlobalConfig.concurrencySshLimit);
                this.setConcurrency(ParallecGlobalConfig.concurrencySshLimit);
            }
            if (this.httpMeta.isPollable()) {
                throw new ParallelTaskInvalidException("Not support pollable job with SSH.");
            }
            this.httpMeta.initValuesNa();
            this.tcpMeta = null;
            this.pingMeta = null;
            this.udpMeta = null;
        } else if (this.requestProtocol == RequestProtocol.PING) {
            if (this.httpMeta.isPollable()) {
                throw new ParallelTaskInvalidException("Not support pollable job with PING.");
            }
            this.httpMeta.initValuesNa();
            this.pingMeta.validation();
            this.sshMeta = null;
            this.tcpMeta = null;
            this.udpMeta = null;
        } else if (this.requestProtocol == RequestProtocol.TCP) {
            if (this.httpMeta.isPollable()) {
                throw new ParallelTaskInvalidException("Not support pollable job with TCP.");
            }
            this.httpMeta.initValuesNa();
            this.tcpMeta.validation();
            this.sshMeta = null;
            this.pingMeta = null;
            this.udpMeta = null;
        } else if (this.requestProtocol == RequestProtocol.UDP) {
            if (this.httpMeta.isPollable()) {
                throw new ParallelTaskInvalidException("Not support pollable job with UDP.");
            }
            this.httpMeta.initValuesNa();
            this.udpMeta.validation();
            this.tcpMeta = null;
            this.sshMeta = null;
            this.pingMeta = null;
        } else {
            this.httpMeta.validation();
            this.sshMeta = null;
            this.tcpMeta = null;
            this.pingMeta = null;
            this.udpMeta = null;
        }
        return true;
    }

    public String generateTaskId() {
        String uuid = UUID.randomUUID().toString().substring(0, 12);
        int size = this.targetHostMeta == null ? 0 : this.targetHostMeta.getHosts().size();
        return "PT_" + size + "_" + PcDateUtils.getNowDateTimeStrConciseNoZone() + "_" + uuid;
    }

    public Double getProgress() {
        if (this.state.equals((Object)ParallelTaskState.IN_PROGRESS)) {
            if (this.requestNum != 0) {
                return 100.0 * ((double)this.responsedNum / (double)this.requestNumActual);
            }
            return 0.0;
        }
        if (this.state.equals((Object)ParallelTaskState.WAITING)) {
            return 0.0;
        }
        if (this.state.equals((Object)ParallelTaskState.COMPLETED_WITH_ERROR) || this.state.equals((Object)ParallelTaskState.COMPLETED_WITHOUT_ERROR)) {
            return 100.0;
        }
        return 0.0;
    }

    public boolean isCompleted() {
        return this.state == ParallelTaskState.COMPLETED_WITHOUT_ERROR || this.state == ParallelTaskState.COMPLETED_WITH_ERROR;
    }

    public AsyncHttpClient getAsyncHttpClient() {
        return this.httpMeta.getAsyncHttpClient();
    }

    public void setAsyncHttpClient(AsyncHttpClient asyncHttpClient) {
        this.httpMeta.setAsyncHttpClient(asyncHttpClient);
    }

    public Map<String, NodeReqResponse> getParallelTaskResult() {
        return this.parallelTaskResult;
    }

    public void setParallelTaskResult(Map<String, NodeReqResponse> parallelTaskResult) {
        this.parallelTaskResult = parallelTaskResult;
    }

    public Map<String, StrStrMap> getReplacementVarMapNodeSpecific() {
        return this.replacementVarMapNodeSpecific;
    }

    public Map<String, String> getReplacementVarMap() {
        return this.replacementVarMap;
    }

    public RequestReplacementType getRequestReplacementType() {
        return this.requestReplacementType;
    }

    public void setRequestReplacementType(RequestReplacementType requestReplacementType) {
        this.requestReplacementType = requestReplacementType;
    }

    public List<TaskErrorMeta> getTaskErrorMetas() {
        return this.taskErrorMetas;
    }

    public String toString() {
        return "ParallelTask [config=" + this.config + ", submitTime=" + this.submitTime + ", executeStartTime=" + this.executeStartTime + ", executionEndTime=" + this.executionEndTime + ", durationSec=" + this.durationSec + ", requestNum=" + this.requestNum + ", requestNumActual=" + this.requestNumActual + ", responsedNum=" + this.responsedNum + ", taskErrorMetas=" + this.taskErrorMetas + ", responseContext=" + this.responseContext + ", state=" + (Object)((Object)this.state) + ", taskId=" + this.taskId + ", handler=" + this.handler + ", aggregateResultMap=" + this.aggregateResultMap + ", parallelTaskResult=" + this.parallelTaskResult + ", httpMeta=" + this.httpMeta + ", targetHostMeta=" + this.targetHostMeta + ", sshMeta=" + this.sshMeta + ", tcpMeta=" + this.tcpMeta + ", pingMeta=" + this.pingMeta + ", executionManager=" + this.executionManager + ", replacementVarMapNodeSpecific=" + this.replacementVarMapNodeSpecific + ", replacementVarMap=" + this.replacementVarMap + ", requestReplacementType=" + (Object)((Object)this.requestReplacementType) + ", requestProtocol=" + (Object)((Object)this.requestProtocol) + ", concurrency=" + this.concurrency + "]";
    }

    public SshMeta getSshMeta() {
        return this.sshMeta;
    }

    public void setSshMeta(SshMeta sshMeta) {
        this.sshMeta = sshMeta;
    }

    public Map<String, Object> getResponseContext() {
        return this.responseContext;
    }

    public TargetHostMeta getTargetHostMeta() {
        return this.targetHostMeta;
    }

    public void setTargetHostMeta(TargetHostMeta targetHostMeta) {
        this.targetHostMeta = targetHostMeta;
    }

    public HttpMeta getHttpMeta() {
        return this.httpMeta;
    }

    public void setHttpMeta(HttpMeta httpMeta) {
        this.httpMeta = httpMeta;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public void setResponseContext(Map<String, Object> responseContext) {
        this.responseContext = responseContext;
    }

    public ParallelTaskConfig getConfig() {
        return this.config;
    }

    public void setConfig(ParallelTaskConfig config) {
        this.config = config;
    }

    public String prettyPrintInfo() {
        return PcStringUtils.renderJson(new ParallelTaskBean(this));
    }

    public boolean saveLogToLocal(String path) {
        String content = PcStringUtils.renderJson(new ParallelTaskBean(this));
        File file = new File(path);
        boolean success = false;
        try {
            FileUtils.writeStringToFile((File)file, (String)content);
            success = true;
        }
        catch (IOException e) {
            logger.error("error writing parallel task to path {} details ", (Object)path, (Object)e);
        }
        logger.info("Save parallel task {} log  to disk at path {}. Success?: {}", new Object[]{this.taskId, path, success});
        return success;
    }

    public boolean saveLogToLocal() {
        String path = ParallecGlobalConfig.taskLogFolderWithSlash + this.taskId + ParallecGlobalConfig.taskLogPostfix;
        return this.saveLogToLocal(path);
    }

    public long getExecutionEndTime() {
        return this.executionEndTime;
    }

    public void setExecutionEndTime(long executionEndTime) {
        this.executionEndTime = executionEndTime;
    }

    public Map<String, SetAndCount> getAggregateResultFullSummary() {
        ConcurrentHashMap<String, SetAndCount> summaryMap = new ConcurrentHashMap<String, SetAndCount>();
        for (Map.Entry<String, LinkedHashSet<String>> entry : this.aggregateResultMap.entrySet()) {
            summaryMap.put(entry.getKey(), new SetAndCount((Set<String>)entry.getValue()));
        }
        return summaryMap;
    }

    public String getAggregatedResultHumanStr() {
        return PcStringUtils.getAggregatedResultHuman(this.aggregateResultMap);
    }

    public Map<String, Integer> getAggregateResultCountSummary() {
        LinkedHashMap<String, Integer> summaryMap = new LinkedHashMap<String, Integer>();
        for (Map.Entry<String, LinkedHashSet<String>> entry : this.aggregateResultMap.entrySet()) {
            summaryMap.put(entry.getKey(), entry.getValue().size());
        }
        return summaryMap;
    }

    public Map<String, LinkedHashSet<String>> getAggregateResultMap() {
        return this.aggregateResultMap;
    }

    public double getDurationSec() {
        return this.durationSec;
    }

    public void setDurationSec(double durationSec) {
        this.durationSec = durationSec;
    }

    public TcpMeta getTcpMeta() {
        return this.tcpMeta;
    }

    public void setTcpMeta(TcpMeta tcpMeta) {
        this.tcpMeta = tcpMeta;
    }

    public RequestProtocol getRequestProtocol() {
        return this.requestProtocol;
    }

    public void setRequestProtocol(RequestProtocol requestProtocol) {
        this.requestProtocol = requestProtocol;
    }

    public int getConcurrency() {
        return this.concurrency;
    }

    public void setConcurrency(int concurrency) {
        this.concurrency = concurrency;
    }

    public long getSubmitTime() {
        return this.submitTime;
    }

    public void setSubmitTime(long submitTime) {
        this.submitTime = submitTime;
    }

    public long getExecuteStartTime() {
        return this.executeStartTime;
    }

    public void setExecuteStartTime(long executeStartTime) {
        this.executeStartTime = executeStartTime;
    }

    public int getRequestNum() {
        return this.requestNum;
    }

    public void setRequestNum(int requestNum) {
        this.requestNum = requestNum;
    }

    public int getRequestNumActual() {
        return this.requestNumActual;
    }

    public void setRequestNumActual(int requestNumActual) {
        this.requestNumActual = requestNumActual;
    }

    public int getResponsedNum() {
        return this.responsedNum;
    }

    public void setResponsedNum(int responsedNum) {
        this.responsedNum = responsedNum;
    }

    public ParallelTaskState getState() {
        return this.state;
    }

    public void setState(ParallelTaskState state) {
        this.state = state;
    }

    public ParallecResponseHandler getHandler() {
        return this.handler;
    }

    public void setHandler(ParallecResponseHandler handler) {
        this.handler = handler;
    }

    public PingMeta getPingMeta() {
        return this.pingMeta;
    }

    public void setPingMeta(PingMeta pingMeta) {
        this.pingMeta = pingMeta;
    }

    public UdpMeta getUdpMeta() {
        return this.udpMeta;
    }

    public void setUdpMeta(UdpMeta udpMeta) {
        this.udpMeta = udpMeta;
    }
}

