/*
 * Decompiled with CFR 0.152.
 */
package io.parallec.core.bean.udp;

import io.parallec.core.config.ParallecGlobalConfig;
import io.parallec.core.exception.ParallelTaskInvalidException;
import io.parallec.core.resources.TcpUdpSshPingResourceStore;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.socket.DatagramChannelFactory;
import org.jboss.netty.handler.codec.string.StringDecoder;
import org.jboss.netty.handler.codec.string.StringEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdpMeta {
    private static Logger logger = LoggerFactory.getLogger(UdpMeta.class);
    public static final ChannelHandler stringDecoder = new StringDecoder();
    public static final ChannelHandler stringEncoder = new StringEncoder();
    private String command;
    private Integer udpPort;
    private Integer udpIdleTimeoutSec;
    private DatagramChannelFactory channelFactory;

    public UdpMeta(String command, int udpPort, int udpIdleTimeoutSec, DatagramChannelFactory channelFactory) {
        this.command = command;
        this.udpPort = udpPort;
        this.udpIdleTimeoutSec = udpIdleTimeoutSec;
        this.channelFactory = channelFactory;
    }

    public UdpMeta() {
        this.command = null;
        this.udpPort = null;
        this.channelFactory = null;
        this.udpIdleTimeoutSec = null;
    }

    public boolean validation() throws ParallelTaskInvalidException {
        if (this.command == null) {
            throw new ParallelTaskInvalidException("command is null for UDP");
        }
        if (this.udpPort == null) {
            throw new ParallelTaskInvalidException("udpPort is null. please set");
        }
        if (this.udpIdleTimeoutSec == null) {
            logger.info("SET DEFAULT UDP CONNECT TIMEOUT: UDP connectTimeoutMillis is set as default");
            this.udpIdleTimeoutSec = ParallecGlobalConfig.udpIdleTimeoutSecDefault;
        }
        if (this.channelFactory == null) {
            logger.info("SET DEFAULT UDP NETTY CHANNEL FACTORY: UDP channelFactory is set as default");
            this.channelFactory = TcpUdpSshPingResourceStore.getInstance().getDatagramChannelFactory();
        }
        return true;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public ChannelFactory getChannelFactory() {
        return this.channelFactory;
    }

    public void setChannelFactory(DatagramChannelFactory channelFactory) {
        this.channelFactory = channelFactory;
    }

    public Integer getUdpPort() {
        return this.udpPort;
    }

    public void setUdpPort(Integer udpPort) {
        this.udpPort = udpPort;
    }

    public Integer getUdpIdleTimeoutSec() {
        return this.udpIdleTimeoutSec;
    }

    public void setUdpIdleTimeoutSec(Integer udpIdleTimeoutSec) {
        this.udpIdleTimeoutSec = udpIdleTimeoutSec;
    }

    public String toString() {
        return "UdpMeta [command=" + this.command + ", udpPort=" + this.udpPort + ", udpIdleTimeoutSec=" + this.udpIdleTimeoutSec + ", channelFactory=" + this.channelFactory + "]";
    }
}

