/*
 * Decompiled with CFR 0.152.
 */
package io.parallec.core.commander.workflow.ping;

import io.parallec.core.bean.ping.PingMeta;
import io.parallec.core.bean.ping.PingMode;
import java.net.InetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PingProvider {
    private static Logger logger = LoggerFactory.getLogger(PingProvider.class);
    private static PingProvider instance = new PingProvider();

    private PingProvider() {
    }

    public static PingProvider getInstance() {
        return instance;
    }

    public boolean isReachableByPing(String targetHost, PingMeta pingMeta) {
        boolean live = this.isReachableByPingHelper(targetHost, pingMeta);
        for (int retryLeft = pingMeta.getNumRetries().intValue(); !live && retryLeft > 0; --retryLeft) {
            live = this.isReachableByPingHelper(targetHost, pingMeta);
        }
        return live;
    }

    public boolean isReachableByPingHelper(String targetHost, PingMeta pingMeta) {
        try {
            if (pingMeta.getMode() == PingMode.INET_ADDRESS_REACHABLE_NEED_ROOT) {
                InetAddress address = InetAddress.getByName(targetHost);
                return address.isReachable(pingMeta.getPingTimeoutMillis());
            }
            String cmd = "";
            cmd = System.getProperty("os.name").startsWith("Windows") ? "ping -n 1 " + targetHost : "ping -c 1 " + targetHost;
            Process myProcess = Runtime.getRuntime().exec(cmd);
            myProcess.waitFor();
            return myProcess.exitValue() == 0;
        }
        catch (Exception e) {
            logger.info("Bad hostname {} with err {} ", (Object)targetHost, (Object)e.getLocalizedMessage());
            return false;
        }
    }
}

