/*
 * Decompiled with CFR 0.152.
 */
package io.parallec.core.monitor;

import com.google.gson.GsonBuilder;
import io.parallec.core.util.PcDateUtils;
import io.parallec.core.util.PcNumberUtils;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorProvider {
    private static Logger logger = LoggerFactory.getLogger(MonitorProvider.class);
    public static int THRESHOLD_PERCENT = 90;
    private static MonitorProvider instance = new MonitorProvider();
    public PerformUsage currentJvmPerformUsage;

    public static MonitorProvider getInstance() {
        return instance;
    }

    private MonitorProvider() {
    }

    public PerformUsage getJVMMemoryUsage() {
        int mb = 0x100000;
        Runtime rt = Runtime.getRuntime();
        PerformUsage usage = new PerformUsage();
        usage.totalMemory = (double)rt.totalMemory() / (double)mb;
        usage.freeMemory = (double)rt.freeMemory() / (double)mb;
        usage.usedMemory = (double)rt.totalMemory() / (double)mb - (double)(rt.freeMemory() / (long)mb);
        usage.maxMemory = (double)rt.maxMemory() / (double)mb;
        usage.memoryUsagePercent = usage.usedMemory / usage.maxMemory * 100.0;
        this.currentJvmPerformUsage = usage;
        return usage;
    }

    public ThreadInfo[] getThreadDump() {
        ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
        return threadMxBean.dumpAllThreads(true, true);
    }

    public int getLiveThreadCount() {
        return ManagementFactory.getThreadMXBean().getThreadCount();
    }

    public ThreadUsage getThreadUsage() {
        ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
        ThreadUsage threadUsage = new ThreadUsage();
        long[] threadIds = threadMxBean.getAllThreadIds();
        threadUsage.liveThreadCount = threadIds.length;
        for (long tId : threadIds) {
            ThreadInfo threadInfo = threadMxBean.getThreadInfo(tId);
            if (threadInfo == null) continue;
            threadUsage.threadData.put(Long.toString(tId), new ThreadData(threadInfo.getThreadName(), threadInfo.getThreadState().name(), threadMxBean.getThreadCpuTime(tId)));
        }
        return threadUsage;
    }

    public String getHealthMemory() {
        StringBuilder sb = new StringBuilder();
        sb.append("Logging JVM Stats\n");
        MonitorProvider mp = MonitorProvider.getInstance();
        PerformUsage perf = mp.getJVMMemoryUsage();
        sb.append(perf.toString());
        if (perf.memoryUsagePercent >= (double)THRESHOLD_PERCENT) {
            ThreadInfo[] threadDump;
            sb.append("========= WARNING: MEM USAGE > " + THRESHOLD_PERCENT + "!!");
            sb.append(" !! Live Threads List=============\n");
            sb.append(mp.getThreadUsage().toString());
            sb.append("========================================\n");
            sb.append("========================JVM Thread Dump====================\n");
            for (ThreadInfo threadInfo : threadDump = mp.getThreadDump()) {
                sb.append(threadInfo.toString() + "\n");
            }
            sb.append("===========================================================\n");
        }
        sb.append("Logged JVM Stats\n");
        return sb.toString();
    }

    public static abstract class Jsonable {
        public String toString() {
            return new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).create().toJson((Object)this);
        }
    }

    public static class PerformUsage
    extends Jsonable {
        public String date = PcDateUtils.getNowDateTimeStrStandard();
        public double totalMemory;
        public double freeMemory;
        public double usedMemory;
        public double maxMemory;
        public double memoryUsagePercent;

        public String getSummary() {
            return PcNumberUtils.getStringFromDouble(this.memoryUsagePercent) + "% (" + PcNumberUtils.getStringFromDouble(this.usedMemory) + "/" + PcNumberUtils.getStringFromDouble(this.totalMemory) + ") Max " + PcNumberUtils.getStringFromDouble(this.maxMemory);
        }
    }

    public static class ThreadData
    extends Jsonable {
        public String threadName;
        public String threadState;
        public long cpuTimeInNanoSeconds;

        public ThreadData(String threadName, String threadState, long cpuTimeInNanoSeconds) {
            this.threadName = threadName;
            this.threadState = threadState;
            this.cpuTimeInNanoSeconds = cpuTimeInNanoSeconds;
        }
    }

    public static class ThreadUsage
    extends Jsonable {
        public int liveThreadCount;
        public Map<String, ThreadData> threadData = new HashMap<String, ThreadData>();
    }
}

