/*
 * Decompiled with CFR 0.152.
 */
package io.parallec.core.resources;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpClientConfigBean;
import io.parallec.core.config.ParallecGlobalConfig;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AsyncHttpClientFactoryEmbed {
    private static Logger logger = LoggerFactory.getLogger(AsyncHttpClientFactoryEmbed.class);
    private final AsyncHttpClient fastClient;
    private final AsyncHttpClient slowClient;

    public AsyncHttpClientFactoryEmbed() {
        AsyncHttpClient fastClient = null;
        AsyncHttpClient slowClient = null;
        try {
            AsyncHttpClientConfigBean configFastClient = new AsyncHttpClientConfigBean();
            logger.info("FastClient: ningFastClientConnectionTimeoutMillis: {}", (Object)ParallecGlobalConfig.ningFastClientConnectionTimeoutMillis);
            configFastClient.setConnectionTimeOutInMs(ParallecGlobalConfig.ningFastClientConnectionTimeoutMillis);
            logger.info("FastClient: ningFastClientRequestTimeoutMillis: {}", (Object)ParallecGlobalConfig.ningFastClientRequestTimeoutMillis);
            configFastClient.setRequestTimeoutInMs(ParallecGlobalConfig.ningFastClientRequestTimeoutMillis);
            fastClient = new AsyncHttpClient((AsyncHttpClientConfig)configFastClient);
            AsyncHttpClientConfigBean configSlowClient = new AsyncHttpClientConfigBean();
            configSlowClient.setConnectionTimeOutInMs(ParallecGlobalConfig.ningSlowClientConnectionTimeoutMillis);
            configSlowClient.setRequestTimeoutInMs(ParallecGlobalConfig.ningSlowClientRequestTimeoutMillis);
            slowClient = new AsyncHttpClient((AsyncHttpClientConfig)configSlowClient);
            this.disableCertificateVerification();
        }
        catch (Exception e) {
            logger.error("ERROR IN HttpClientFactoryEmbed " + e.getLocalizedMessage());
        }
        this.fastClient = fastClient;
        this.slowClient = slowClient;
    }

    public AsyncHttpClient getFastClient() {
        return this.fastClient;
    }

    public AsyncHttpClient getSlowClient() {
        return this.slowClient;
    }

    private void disableCertificateVerification() throws KeyManagementException, NoSuchAlgorithmException {
        TrustManager[] trustAllCerts = new TrustManager[]{new CustomTrustManager()};
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, trustAllCerts, new SecureRandom());
        SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
        HttpsURLConnection.setDefaultSSLSocketFactory(sslSocketFactory);
        HostnameVerifier verifier = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(verifier);
    }

    public void state() {
        logger.info("Initializing Default AHC CLient Factory...");
    }

    public static class CustomTrustManager
    implements X509TrustManager {
        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }
}

