/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.cfenv.jdbc;

import io.pivotal.cfenv.core.CfCredentials;
import io.pivotal.cfenv.core.CfService;
import io.pivotal.cfenv.core.UriInfo;
import io.pivotal.cfenv.jdbc.AbstractJdbcUrlCreator;

public class OracleJdbcUrlCreator
extends AbstractJdbcUrlCreator {
    public static final String ORACLE_SCHEME = "oracle";
    public static final String ORACLE_LABEL = "oracle";

    @Override
    public boolean isDatabaseService(CfService cfService) {
        return this.jdbcUrlMatchesScheme(cfService, "oracle") || cfService.existsByLabelStartsWith("oracle") || cfService.existsByUriSchemeStartsWith(new String[]{"oracle"}) || cfService.existsByCredentialsContainsUriField(new String[]{"oracle"});
    }

    @Override
    public String getDriverClassName() {
        return "oracle.jdbc.OracleDriver";
    }

    @Override
    public String buildJdbcUrlFromUriField(CfCredentials cfCredentials) {
        UriInfo uriInfo = cfCredentials.getUriInfo("oracle");
        return String.format("jdbc:%s:thin:%s/%s@%s:%d/%s", "oracle", uriInfo.getUsername(), uriInfo.getPassword(), uriInfo.getHost(), uriInfo.getPort(), uriInfo.getPath());
    }
}

