/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.jmx;

import io.prometheus.jmx.BuildInfoMetrics;
import io.prometheus.jmx.JmxCollector;
import io.prometheus.jmx.common.http.ConfigurationException;
import io.prometheus.jmx.common.http.HTTPServerFactory;
import io.prometheus.metrics.exporter.httpserver.HTTPServer;
import io.prometheus.metrics.instrumentation.jvm.JvmMetrics;
import io.prometheus.metrics.model.registry.PrometheusRegistry;
import java.io.File;
import java.io.PrintStream;
import java.lang.instrument.Instrumentation;
import java.net.InetAddress;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaAgent {
    public static final String CONFIGURATION_REGEX = "^(?:((?:[\\w.-]+)|(?:\\[.+])):)?(\\d{1,5}):(.+)";
    private static final String DEFAULT_HOST = "0.0.0.0";
    private static HTTPServer httpServer;

    public static void agentmain(String agentArgument, Instrumentation instrumentation) throws Exception {
        JavaAgent.premain(agentArgument, instrumentation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void premain(String agentArgument, Instrumentation instrumentation) throws Exception {
        try {
            Config config = JavaAgent.parseConfig(agentArgument);
            new BuildInfoMetrics().register(PrometheusRegistry.defaultRegistry);
            JvmMetrics.builder().register(PrometheusRegistry.defaultRegistry);
            new JmxCollector(new File(config.file), JmxCollector.Mode.AGENT).register(PrometheusRegistry.defaultRegistry);
            String host = config.host != null ? config.host : DEFAULT_HOST;
            httpServer = new HTTPServerFactory().createHTTPServer(InetAddress.getByName(host), config.port, PrometheusRegistry.defaultRegistry, new File(config.file));
        }
        catch (Throwable t) {
            PrintStream printStream = System.err;
            synchronized (printStream) {
                System.err.println("Failed to start Prometheus JMX Exporter");
                System.err.println();
                t.printStackTrace();
                System.err.println();
                System.err.println("Prometheus JMX Exporter exiting");
                System.err.flush();
            }
            System.exit(1);
        }
    }

    private static Config parseConfig(String args) {
        Pattern pattern = Pattern.compile(CONFIGURATION_REGEX);
        Matcher matcher = pattern.matcher(args);
        if (!matcher.matches()) {
            System.err.println("Usage: -javaagent:/path/to/JavaAgent.jar=[host:]<port>:<yaml configuration file> ");
            throw new ConfigurationException("Malformed arguments - " + args);
        }
        String givenHost = matcher.group(1);
        String givenPort = matcher.group(2);
        String givenConfigFile = matcher.group(3);
        int port = Integer.parseInt(givenPort);
        return new Config(givenHost, port, givenConfigFile);
    }

    private static class Config {
        String host;
        int port;
        String file;

        Config(String host, int port, String file) {
            this.host = host;
            this.port = port;
            this.file = file;
        }
    }
}

