/*
 * Decompiled with CFR 0.152.
 */
package ratpack.error.internal;

import io.netty.handler.codec.http.HttpResponseStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ratpack.error.internal.ErrorHandler;
import ratpack.error.internal.ErrorPageRenderer;
import ratpack.handling.Context;
import ratpack.http.Request;

public class DefaultDevelopmentErrorHandler
implements ErrorHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDevelopmentErrorHandler.class);

    @Override
    public void error(final Context context, final Throwable throwable) {
        LOGGER.error("exception thrown for request to " + context.getRequest().getRawUri(), throwable);
        context.getResponse().status(500);
        new ErrorPageRenderer(){

            @Override
            protected void render() {
                this.render(context, "Internal Error", w -> {
                    this.messages((ErrorPageRenderer.BodyWriter)w, "Internal Error", () -> {
                        Request request = context.getRequest();
                        this.meta((ErrorPageRenderer.BodyWriter)w, m -> m.put((Object)"URI:", (Object)request.getRawUri()).put((Object)"Method:", (Object)request.getMethod().getName()));
                    });
                    this.stack((ErrorPageRenderer.BodyWriter)w, null, throwable);
                });
            }
        };
    }

    @Override
    public void error(final Context context, int statusCode) {
        final HttpResponseStatus status = HttpResponseStatus.valueOf((int)statusCode);
        final Request request = context.getRequest();
        LOGGER.error(statusCode + " client error for request to " + request.getRawUri());
        context.getResponse().status(statusCode);
        new ErrorPageRenderer(){

            @Override
            protected void render() {
                this.render(context, status.reasonPhrase(), w -> this.messages((ErrorPageRenderer.BodyWriter)w, "Client Error", () -> this.meta((ErrorPageRenderer.BodyWriter)w, m -> m.put((Object)"URI:", (Object)request.getRawUri()).put((Object)"Method:", (Object)request.getMethod().getName()).put((Object)"Status Code:", (Object)status.code()).put((Object)"Phrase:", (Object)status.reasonPhrase()))));
            }
        };
    }
}

