/*
 * Decompiled with CFR 0.152.
 */
package ratpack.file.internal;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import ratpack.file.FileSystemBinding;
import ratpack.file.FileSystemChecksumService;
import ratpack.func.Function;

public class DefaultFileSystemChecksumService
implements FileSystemChecksumService {
    private final Function<? super InputStream, ? extends String> checksummer;
    private final FileSystemBinding fileSystemBinding;

    public DefaultFileSystemChecksumService(FileSystemBinding fileSystemBinding, Function<? super InputStream, ? extends String> checksummer) {
        this.checksummer = checksummer;
        this.fileSystemBinding = fileSystemBinding;
    }

    @Override
    public String checksum(String path) throws Exception {
        Path child = this.fileSystemBinding.file(path);
        return this.getChecksum(child);
    }

    private String getChecksum(Path child) throws Exception {
        try (InputStream inputStream = Files.newInputStream(child, StandardOpenOption.READ);){
            String string = this.checksummer.apply(inputStream);
            return string;
        }
    }
}

