/*
 * Decompiled with CFR 0.152.
 */
package ratpack.registry.internal;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import ratpack.func.Action;
import ratpack.registry.PredicateCacheability;
import ratpack.registry.Registry;
import ratpack.registry.RegistryBacking;
import ratpack.util.ExceptionUtils;

public class CachingBackedRegistry
implements Registry {
    private final RegistryBacking registryBacking;
    private final LoadingCache<TypeToken<?>, Iterable<? extends Supplier<?>>> supplierCache = CacheBuilder.newBuilder().build(new CacheLoader<TypeToken<?>, Iterable<? extends Supplier<?>>>(){

        public Iterable<? extends Supplier<?>> load(TypeToken<?> key) throws Exception {
            return (Iterable)Objects.firstNonNull(CachingBackedRegistry.this.registryBacking.provide(key), (Object)ImmutableList.of());
        }
    });
    private final LoadingCache<PredicateCacheability.CacheKey<?>, Iterable<? extends Supplier<?>>> predicateCache = CacheBuilder.newBuilder().build(new CacheLoader<PredicateCacheability.CacheKey<?>, Iterable<? extends Supplier<?>>>(){

        public Iterable<? extends Supplier<?>> load(PredicateCacheability.CacheKey<?> key) throws Exception {
            return this.get(key);
        }

        private <T> Iterable<? extends Supplier<T>> get(final PredicateCacheability.CacheKey<T> key) throws ExecutionException {
            Iterable suppliers = CachingBackedRegistry.this.getSuppliers(key.type);
            return FluentIterable.from(suppliers).filter(new Predicate<Supplier<T>>(){

                public boolean apply(Supplier<T> input) {
                    return key.predicate.apply(input.get());
                }
            }).toList();
        }
    });

    public CachingBackedRegistry(RegistryBacking registryBacking) {
        this.registryBacking = registryBacking;
    }

    public <T> Optional<T> maybeGet(TypeToken<T> type) {
        Iterator<Supplier<T>> suppliers = this.getSuppliers(type).iterator();
        if (!suppliers.hasNext()) {
            return Optional.empty();
        }
        return Optional.of(suppliers.next().get());
    }

    @Override
    public <O> Iterable<? extends O> getAll(TypeToken<O> type) {
        return this.transformToInstances(this.getSuppliers(type));
    }

    protected <O> Iterable<O> transformToInstances(Iterable<? extends Supplier<O>> suppliers) {
        return Iterables.transform(suppliers, s -> s.get());
    }

    protected <T> Iterable<? extends Supplier<T>> getSuppliers(TypeToken<T> type) {
        try {
            Iterable suppliers = (Iterable)this.supplierCache.get(type);
            return (Iterable)Objects.firstNonNull((Object)suppliers, (Object)ImmutableList.of());
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw ExceptionUtils.uncheck(ExceptionUtils.toException(e.getCause()));
        }
    }

    protected <T> Iterable<? extends Supplier<T>> getSuppliers(TypeToken<T> type, Predicate<? super T> predicate) {
        try {
            Iterable suppliers = (Iterable)this.predicateCache.get(new PredicateCacheability.CacheKey<T>(type, predicate));
            return (Iterable)Objects.firstNonNull((Object)suppliers, (Object)ImmutableList.of());
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw ExceptionUtils.uncheck(ExceptionUtils.toException(e.getCause()));
        }
    }

    @Override
    public <T> Optional<T> first(TypeToken<T> type, Predicate<? super T> predicate) {
        Iterator<T> matching = this.all(type, predicate).iterator();
        if (!matching.hasNext()) {
            return Optional.empty();
        }
        return Optional.of(matching.next());
    }

    @Override
    public <T> Iterable<? extends T> all(TypeToken<T> type, Predicate<? super T> predicate) {
        if (PredicateCacheability.isCacheable(predicate)) {
            return this.transformToInstances(this.getSuppliers(type, predicate));
        }
        return Iterables.filter(this.getAll(type), predicate);
    }

    @Override
    public <T> boolean each(TypeToken<T> type, Predicate<? super T> predicate, Action<? super T> action) throws Exception {
        if (PredicateCacheability.isCacheable(predicate)) {
            Iterable<T> all = this.all(type, predicate);
            boolean any = false;
            for (T t : all) {
                any = true;
                action.execute(t);
            }
            return any;
        }
        boolean foundMatch = false;
        Iterable<Supplier<T>> suppliers = this.getSuppliers(type);
        for (Supplier<T> supplier : suppliers) {
            Object instance = supplier.get();
            if (!predicate.apply(instance)) continue;
            action.execute(instance);
            foundMatch = true;
        }
        return foundMatch;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CachingBackedRegistry that = (CachingBackedRegistry)o;
        return this.registryBacking.equals(that.registryBacking);
    }

    public int hashCode() {
        return this.registryBacking.hashCode();
    }
}

