/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server;

import com.google.common.base.Throwables;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import java.io.File;
import ratpack.file.BaseDirRequiredException;
import ratpack.func.Function;
import ratpack.handling.Handler;
import ratpack.handling.internal.FactoryHandler;
import ratpack.launch.HandlerFactory;
import ratpack.launch.LaunchConfig;
import ratpack.launch.LaunchException;
import ratpack.reload.internal.ClassUtil;
import ratpack.reload.internal.ReloadableFileBackedFactory;
import ratpack.server.RatpackServer;
import ratpack.server.Stopper;
import ratpack.server.internal.NettyRatpackServer;
import ratpack.server.internal.RatpackChannelInitializer;

public abstract class RatpackServerBuilder {
    private RatpackServerBuilder() {
    }

    public static RatpackServer build(LaunchConfig launchConfig) {
        Function<Stopper, ChannelInitializer<SocketChannel>> channelInitializer = RatpackServerBuilder.buildChannelInitializer(launchConfig);
        return new NettyRatpackServer(launchConfig, channelInitializer);
    }

    private static Function<Stopper, ChannelInitializer<SocketChannel>> buildChannelInitializer(LaunchConfig launchConfig) {
        return stopper -> new RatpackChannelInitializer(launchConfig, RatpackServerBuilder.createHandler(launchConfig), (Stopper)stopper);
    }

    private static Handler createHandler(LaunchConfig launchConfig) {
        File classFile;
        HandlerFactory handlerFactory = launchConfig.getHandlerFactory();
        if (launchConfig.isDevelopment() && (classFile = ClassUtil.getClassFile(handlerFactory)) != null) {
            ReloadableFileBackedFactory<Handler> factory = new ReloadableFileBackedFactory<Handler>(classFile.toPath(), true, (file, bytes) -> RatpackServerBuilder.createHandler(launchConfig, handlerFactory));
            return new FactoryHandler(factory);
        }
        return RatpackServerBuilder.createHandler(launchConfig, handlerFactory);
    }

    private static Handler createHandler(LaunchConfig launchConfig, HandlerFactory handlerFactory) {
        try {
            return handlerFactory.create(launchConfig);
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, BaseDirRequiredException.class);
            throw new LaunchException("Could not create handler via handler factory: " + handlerFactory.getClass().getName(), e);
        }
    }
}

