/*
 * Decompiled with CFR 0.152.
 */
package ratpack.stream;

import java.util.Collection;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;
import ratpack.exec.ExecControl;
import ratpack.exec.Promise;
import ratpack.func.Action;
import ratpack.func.Function;
import ratpack.launch.LaunchConfig;
import ratpack.stream.StreamEvent;
import ratpack.stream.TransformablePublisher;
import ratpack.stream.YieldRequest;
import ratpack.stream.internal.BufferingPublisher;
import ratpack.stream.internal.DefaultTransformablePublisher;
import ratpack.stream.internal.FanOutPublisher;
import ratpack.stream.internal.FlatMapPublisher;
import ratpack.stream.internal.GatedPublisher;
import ratpack.stream.internal.IterablePublisher;
import ratpack.stream.internal.MapPublisher;
import ratpack.stream.internal.MergingPublisher;
import ratpack.stream.internal.MulticastPublisher;
import ratpack.stream.internal.PeriodicPublisher;
import ratpack.stream.internal.SingleElementSubscriber;
import ratpack.stream.internal.WiretapPublisher;
import ratpack.stream.internal.YieldingPublisher;
import ratpack.util.Types;

public class Streams {
    public static <T> TransformablePublisher<T> transformable(Publisher<T> publisher) {
        if (publisher instanceof TransformablePublisher) {
            return (TransformablePublisher)Types.cast(publisher);
        }
        return new DefaultTransformablePublisher<T>(publisher);
    }

    public static <T> TransformablePublisher<T> publish(Iterable<T> iterable) {
        return Streams.transformable(new IterablePublisher<T>(iterable));
    }

    public static <T> TransformablePublisher<T> yield(Function<? super YieldRequest, T> producer) {
        return Streams.transformable(new YieldingPublisher<T>(producer));
    }

    public static <T> TransformablePublisher<T> constant(T item) {
        return Streams.transformable(Streams.yield(yieldRequest -> item));
    }

    public static <I, O> TransformablePublisher<O> map(Publisher<I> input, Function<? super I, ? extends O> function) {
        return Streams.transformable(new MapPublisher<O, I>(input, function));
    }

    public static <I, O> TransformablePublisher<O> flatMap(Publisher<I> input, Function<? super I, ? extends Promise<? extends O>> function) {
        return Streams.transformable(new FlatMapPublisher(input, function));
    }

    public static <T> TransformablePublisher<T> buffer(Publisher<T> publisher) {
        return Streams.transformable(new BufferingPublisher<T>(publisher));
    }

    public static <T> TransformablePublisher<T> gate(Publisher<T> publisher, Action<? super Runnable> valveReceiver) {
        return Streams.transformable(new GatedPublisher<T>(publisher, valveReceiver));
    }

    public static <T> TransformablePublisher<T> periodically(ScheduledExecutorService executorService, long delay, TimeUnit timeUnit, Function<Integer, T> producer) {
        return Streams.buffer(new PeriodicPublisher<T>(executorService, producer, delay, timeUnit));
    }

    public static <T> TransformablePublisher<T> periodically(LaunchConfig launchConfig, long delay, TimeUnit timeUnit, Function<Integer, T> producer) {
        return Streams.buffer(new PeriodicPublisher<T>(launchConfig.getExecController().getExecutor(), producer, delay, timeUnit));
    }

    public static <T> TransformablePublisher<T> wiretap(Publisher<T> publisher, Action<? super StreamEvent<? super T>> listener) {
        return Streams.transformable(new WiretapPublisher<T>(publisher, listener));
    }

    public static <T> TransformablePublisher<T> multicast(Publisher<T> publisher) {
        return Streams.transformable(new MulticastPublisher<T>(publisher));
    }

    public static <T> TransformablePublisher<T> fanOut(Publisher<Collection<T>> publisher) {
        return Streams.buffer(new FanOutPublisher<T>(publisher));
    }

    @SafeVarargs
    public static <T> TransformablePublisher<T> merge(Publisher<? extends T> ... publishers) {
        return Streams.buffer(new MergingPublisher<T>(publishers));
    }

    public static <T> Promise<T> toPromise(Publisher<T> publisher) {
        return Streams.toPromise(ExecControl.current(), publisher);
    }

    public static <T> Promise<T> toPromise(ExecControl execControl, Publisher<T> publisher) {
        return execControl.promise(f -> publisher.subscribe(SingleElementSubscriber.to(f::accept)));
    }
}

