/*
 * Decompiled with CFR 0.152.
 */
package ratpack.stream.internal;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class FanOutPublisher<T>
implements Publisher<T> {
    private final Publisher<Collection<T>> upstreamIterablePublisher;

    public FanOutPublisher(Publisher<Collection<T>> publisher) {
        this.upstreamIterablePublisher = publisher;
    }

    public void subscribe(final Subscriber<? super T> subscriber) {
        this.upstreamIterablePublisher.subscribe(new Subscriber<Iterable<T>>(){
            private Subscription subscription;
            private final AtomicBoolean done = new AtomicBoolean();

            public void onSubscribe(Subscription s) {
                this.subscription = s;
                subscriber.onSubscribe(this.subscription);
            }

            public void onNext(Iterable<T> iterable) {
                for (Object element : iterable) {
                    subscriber.onNext(element);
                }
            }

            public void onError(Throwable t) {
                if (this.done.compareAndSet(false, true)) {
                    subscriber.onError(t);
                }
            }

            public void onComplete() {
                if (this.done.compareAndSet(false, true)) {
                    subscriber.onComplete();
                }
            }
        });
    }
}

