/*
 * Decompiled with CFR 0.152.
 */
package ratpack.stream.internal;

import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import ratpack.exec.Promise;
import ratpack.func.Function;

public class FlatMapPublisher<O, I>
implements Publisher<O> {
    private final Publisher<I> input;
    private final Function<? super I, ? extends Promise<? extends O>> function;

    public FlatMapPublisher(Publisher<I> input, Function<? super I, ? extends Promise<? extends O>> function) {
        this.input = input;
        this.function = function;
    }

    public void subscribe(final Subscriber<? super O> outSubscriber) {
        this.input.subscribe(new Subscriber<I>(){
            private Subscription subscription;
            private final AtomicBoolean done = new AtomicBoolean();

            public void onSubscribe(Subscription subscription) {
                this.subscription = subscription;
                outSubscriber.onSubscribe(this.subscription);
            }

            public void onNext(I in) {
                Promise out;
                try {
                    out = (Promise)FlatMapPublisher.this.function.apply(in);
                }
                catch (Throwable throwable) {
                    this.subscription.cancel();
                    this.onError(throwable);
                    return;
                }
                out.onError((? super Throwable e) -> {
                    this.subscription.cancel();
                    this.onError((Throwable)e);
                }).then(v -> {
                    if (!this.done.get()) {
                        outSubscriber.onNext(v);
                    }
                });
            }

            public void onError(Throwable t) {
                if (this.done.compareAndSet(false, true)) {
                    outSubscriber.onError(t);
                }
            }

            public void onComplete() {
                if (this.done.compareAndSet(false, true)) {
                    outSubscriber.onComplete();
                }
            }
        });
    }
}

