/*
 * Decompiled with CFR 0.152.
 */
package ratpack.handling.internal;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Optional;
import ratpack.registry.Registry;

public abstract class Extractions {
    private Extractions() {
    }

    public static Object[] extract(List<TypeToken<?>> types, Registry registry) {
        Object[] services = new Object[types.size()];
        Extractions.extract(types, registry, services, 0);
        return services;
    }

    public static void extract(List<TypeToken<?>> types, Registry registry, Object[] services, int startIndex) {
        for (int i = 0; i < types.size(); ++i) {
            TypeToken<?> type = types.get(i);
            if (type.getRawType().equals(Optional.class)) {
                Optional optional;
                TypeToken paramType;
                try {
                    paramType = type.resolveType(Optional.class.getMethod("get", new Class[0]).getGenericReturnType());
                }
                catch (NoSuchMethodException e) {
                    throw new InternalError("Optional class does not have get method");
                }
                services[i + startIndex] = optional = registry.maybeGet(paramType);
                continue;
            }
            Object service = registry.get(type);
            services[i + startIndex] = service;
        }
    }
}

