/*
 * Decompiled with CFR 0.152.
 */
package ratpack.exec.internal;

import io.netty.util.concurrent.FastThreadLocal;
import java.util.Optional;
import ratpack.exec.ExecController;
import ratpack.exec.ExecutionException;
import ratpack.exec.UnmanagedThreadException;
import ratpack.func.Factory;

public class ThreadBinding {
    private final boolean compute;
    private final ExecController execController;
    private static final FastThreadLocal<ThreadBinding> STORAGE = new FastThreadLocal();

    public ThreadBinding(boolean compute, ExecController execController) {
        this.compute = compute;
        this.execController = execController;
    }

    static void bind(boolean compute, ExecController execController) {
        STORAGE.set((Object)new ThreadBinding(compute, execController));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T bindFor(boolean compute, ExecController execController, Factory<T> function) throws Exception {
        ThreadBinding current = (ThreadBinding)STORAGE.get();
        if (current != null && current.getExecController() == execController) {
            return function.create();
        }
        ThreadBinding.bind(compute, execController);
        try {
            T t = function.create();
            return t;
        }
        finally {
            STORAGE.remove();
            if (current != null) {
                STORAGE.set((Object)current);
            }
        }
    }

    public static Optional<ThreadBinding> get() {
        return Optional.ofNullable(STORAGE.get());
    }

    public boolean isCompute() {
        return this.compute;
    }

    public ExecController getExecController() {
        return this.execController;
    }

    public static void requireComputeThread(String message) {
        if (!ThreadBinding.get().orElseThrow(UnmanagedThreadException::new).isCompute()) {
            throw new ExecutionException(ThreadBinding.toMessage(message));
        }
    }

    public static void requireBlockingThread(String message) {
        if (ThreadBinding.get().orElseThrow(UnmanagedThreadException::new).isCompute()) {
            throw new ExecutionException(ThreadBinding.toMessage(message));
        }
    }

    private static String toMessage(String message) {
        return message + " - current thread name = '" + Thread.currentThread().getName() + "'.";
    }
}

