/*
 * Decompiled with CFR 0.152.
 */
package ratpack.file.internal;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.activation.MimetypesFileTypeMap;
import ratpack.file.MimeTypes;

public class ActivationBackedMimeTypes
implements MimeTypes {
    private static final MimetypesFileTypeMap MIME_TYPES_MAP = new MimetypesFileTypeMap();
    public static final MimeTypes INSTANCE = new ActivationBackedMimeTypes();

    private ActivationBackedMimeTypes() {
    }

    @Override
    public String getContentType(String name) {
        return MIME_TYPES_MAP.getContentType(name);
    }

    private static Set<String> extractKnownMimeTypes() {
        try {
            GetMimeTypeFunction getMimeTypeFunction = new GetMimeTypeFunction();
            Field typeHashField = ActivationBackedMimeTypes.makeFieldAccessible(Class.forName("com.sun.activation.registries.MimeTypeFile"), "type_hash");
            Field mimeTypeFilesField = ActivationBackedMimeTypes.makeFieldAccessible(MimetypesFileTypeMap.class, "DB");
            Object mimeTypeFiles = mimeTypeFilesField.get(MIME_TYPES_MAP);
            HashSet mimeTypes = Sets.newHashSet();
            for (int i = 0; i < Array.getLength(mimeTypeFiles); ++i) {
                Object mimeTypeFile = Array.get(mimeTypeFiles, i);
                if (mimeTypeFile == null) continue;
                Map typeHash = (Map)typeHashField.get(mimeTypeFile);
                Iterables.addAll((Collection)mimeTypes, (Iterable)Iterables.transform(typeHash.values(), (Function)getMimeTypeFunction));
            }
            return ImmutableSet.copyOf((Collection)mimeTypes);
        }
        catch (NullPointerException | ReflectiveOperationException ex) {
            return ImmutableSet.of();
        }
    }

    private static Field makeFieldAccessible(Class<?> clazz, String fieldName) throws ReflectiveOperationException {
        Field field = clazz.getDeclaredField(fieldName);
        field.setAccessible(true);
        return field;
    }

    public static ImmutableSet<String> getDefaultExcludedMimeTypes() {
        Set<String> knownMimeTypes = ActivationBackedMimeTypes.extractKnownMimeTypes();
        ImmutableSet compressedArchiveTypes = ImmutableSet.of((Object)"application/compress", (Object)"application/zip", (Object)"application/gzip");
        Iterable knownExceptNonXmlImagesAudioAndVideo = Iterables.filter(knownMimeTypes, type -> (type.startsWith("image/") || type.startsWith("audio/") || type.startsWith("video/")) && !type.endsWith("+xml"));
        return ImmutableSet.builder().addAll((Iterable)compressedArchiveTypes).addAll(knownExceptNonXmlImagesAudioAndVideo).build();
    }

    private static class GetMimeTypeFunction
    implements Function<Object, String> {
        private final Method getMIMEType = Class.forName("com.sun.activation.registries.MimeTypeEntry").getMethod("getMIMEType", new Class[0]);

        GetMimeTypeFunction() throws ReflectiveOperationException {
        }

        public String apply(Object entry) {
            try {
                return (String)this.getMIMEType.invoke(entry, new Object[0]);
            }
            catch (ReflectiveOperationException ex) {
                throw new NullPointerException("Could not get mime type: " + ex.getMessage());
            }
        }
    }
}

