/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server.internal;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.io.ByteSource;
import com.google.common.reflect.TypeToken;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import ratpack.config.ConfigData;
import ratpack.config.ConfigDataBuilder;
import ratpack.config.ConfigObject;
import ratpack.config.ConfigSource;
import ratpack.config.EnvironmentParser;
import ratpack.config.internal.DefaultConfigData;
import ratpack.config.internal.DefaultConfigDataBuilder;
import ratpack.config.internal.module.SSLContextDeserializer;
import ratpack.config.internal.module.ServerConfigDataDeserializer;
import ratpack.file.FileSystemBinding;
import ratpack.func.Action;
import ratpack.func.Function;
import ratpack.impose.ForceDevelopmentImposition;
import ratpack.impose.ForceServerListenPortImposition;
import ratpack.impose.Impositions;
import ratpack.impose.ServerConfigImposition;
import ratpack.server.ServerConfig;
import ratpack.server.ServerConfigBuilder;
import ratpack.server.internal.DefaultServerConfig;
import ratpack.server.internal.ServerConfigData;
import ratpack.server.internal.ServerEnvironment;

public class DefaultServerConfigBuilder
implements ServerConfigBuilder {
    private final DefaultConfigDataBuilder configDataBuilder;
    private final Map<String, TypeToken<?>> required = Maps.newHashMap();
    private final BaseDirSupplier baseDirSupplier = new BaseDirSupplier();
    private final ServerEnvironment serverEnvironment;
    private final Impositions impositions;

    public DefaultServerConfigBuilder(ServerEnvironment serverEnvironment, Impositions impositions) {
        this.impositions = impositions;
        this.configDataBuilder = new DefaultConfigDataBuilder(serverEnvironment);
        this.serverEnvironment = serverEnvironment;
    }

    private DefaultServerConfigBuilder(DefaultConfigDataBuilder configDataBuilder, Map<String, TypeToken<?>> required, BaseDirSupplier baseDirSupplier, ServerEnvironment serverEnvironment, Impositions impositions) {
        this.configDataBuilder = configDataBuilder.copy();
        this.required.putAll(required);
        this.baseDirSupplier.baseDir = baseDirSupplier.baseDir;
        this.serverEnvironment = serverEnvironment;
        this.impositions = impositions;
    }

    private DefaultServerConfigBuilder copy() {
        return new DefaultServerConfigBuilder(this.configDataBuilder, this.required, this.baseDirSupplier, this.serverEnvironment, this.impositions);
    }

    @Override
    public ObjectMapper getObjectMapper() {
        return this.configDataBuilder.getObjectMapper();
    }

    @Override
    public ServerConfigBuilder baseDir(Path baseDir) {
        this.baseDirSupplier.baseDir = FileSystemBinding.of(baseDir);
        return this;
    }

    private ServerConfigBuilder addToServer(Consumer<? super ObjectNode> action) {
        DefaultServerConfigBuilder.addToServer(this.configDataBuilder, action);
        return this;
    }

    private static void addToServer(ConfigDataBuilder configDataBuilder, Consumer<? super ObjectNode> action) {
        configDataBuilder.add((m, f) -> {
            ObjectNode rootNode = new ObjectNode(configDataBuilder.getObjectMapper().getNodeFactory());
            ObjectNode server = rootNode.putObject("server");
            action.accept(server);
            return rootNode;
        });
    }

    @Override
    public ServerConfigBuilder port(int port) {
        return this.addToServer(n -> n.put("port", port));
    }

    @Override
    public ServerConfigBuilder address(InetAddress address) {
        return this.addToServer(n -> n.putPOJO("address", (Object)address));
    }

    @Override
    public ServerConfigBuilder development(boolean development) {
        return this.addToServer(n -> n.put("development", development));
    }

    @Override
    public ServerConfigBuilder threads(int threads) {
        if (threads < 1) {
            throw new IllegalArgumentException("'threads' must be > 0");
        }
        return this.addToServer(n -> n.put("threads", threads));
    }

    @Override
    public ServerConfigBuilder publicAddress(URI publicAddress) {
        return this.addToServer(n -> n.putPOJO("publicAddress", (Object)publicAddress));
    }

    @Override
    public ServerConfigBuilder maxContentLength(int maxContentLength) {
        return this.addToServer(n -> n.put("maxContentLength", maxContentLength));
    }

    @Override
    public ServerConfigBuilder maxChunkSize(int maxChunkSize) {
        return this.addToServer(n -> n.put("maxChunkSize", maxChunkSize));
    }

    @Override
    public ServerConfigBuilder maxInitialLineLength(int maxInitialLineLength) {
        return this.addToServer(n -> n.put("maxInitialLineLength", maxInitialLineLength));
    }

    @Override
    public ServerConfigBuilder maxHeaderSize(int maxHeaderSize) {
        return this.addToServer(n -> n.put("maxHeaderSize", maxHeaderSize));
    }

    @Override
    public ServerConfigBuilder connectTimeoutMillis(int connectTimeoutMillis) {
        return this.addToServer(n -> n.put("connectTimeoutMillis", connectTimeoutMillis));
    }

    @Override
    public ServerConfigBuilder maxMessagesPerRead(int maxMessagesPerRead) {
        return this.addToServer(n -> n.put("maxMessagesPerRead", maxMessagesPerRead));
    }

    @Override
    public ServerConfigBuilder receiveBufferSize(int receiveBufferSize) {
        return this.addToServer(n -> n.put("receiveBufferSize", receiveBufferSize));
    }

    @Override
    public ServerConfigBuilder writeSpinCount(int writeSpinCount) {
        return this.addToServer(n -> n.put("writeSpinCount", writeSpinCount));
    }

    @Override
    public ServerConfigBuilder ssl(SSLContext sslContext) {
        return this.addToServer(n -> n.putPOJO("ssl", (Object)sslContext));
    }

    @Override
    public ServerConfigBuilder requireClientSslAuth(boolean requireClientSslAuth) {
        return this.addToServer(n -> n.put("requireClientSslAuth", requireClientSslAuth));
    }

    @Override
    public ServerConfigBuilder configureObjectMapper(Action<ObjectMapper> action) {
        this.configDataBuilder.configureObjectMapper(action);
        return this;
    }

    @Override
    public ServerConfigBuilder add(ConfigSource configSource) {
        this.configDataBuilder.add(configSource);
        return this;
    }

    @Override
    public ServerConfigBuilder env(String prefix, Function<String, String> mapFunc) {
        this.configDataBuilder.env(prefix, mapFunc);
        return this;
    }

    @Override
    public ServerConfigBuilder env(EnvironmentParser environmentParser) {
        this.configDataBuilder.env(environmentParser);
        return this;
    }

    @Override
    public ServerConfigBuilder env() {
        this.configDataBuilder.env();
        return this;
    }

    @Override
    public ServerConfigBuilder env(String prefix) {
        this.configDataBuilder.env(prefix);
        return this;
    }

    @Override
    public ServerConfigBuilder args(String[] args) {
        this.configDataBuilder.args(args);
        return this;
    }

    @Override
    public ServerConfigBuilder args(String separator, String[] args) {
        this.configDataBuilder.args(separator, args);
        return this;
    }

    @Override
    public ServerConfigBuilder args(String prefix, String separator, String[] args) {
        this.configDataBuilder.args(prefix, separator, args);
        return this;
    }

    @Override
    public ServerConfigBuilder json(ByteSource byteSource) {
        this.configDataBuilder.json(byteSource);
        return this;
    }

    @Override
    public ServerConfigBuilder json(Path path) {
        this.configDataBuilder.json(path);
        return this;
    }

    @Override
    public ServerConfigBuilder json(URL url) {
        this.configDataBuilder.json(url);
        return this;
    }

    @Override
    public ServerConfigBuilder props(ByteSource byteSource) {
        this.configDataBuilder.props(byteSource);
        return this;
    }

    @Override
    public ServerConfigBuilder props(Path path) {
        this.configDataBuilder.props(path);
        return this;
    }

    @Override
    public ServerConfigBuilder props(Properties properties) {
        this.configDataBuilder.props(properties);
        return this;
    }

    @Override
    public ServerConfigBuilder props(URL url) {
        this.configDataBuilder.props(url);
        return this;
    }

    @Override
    public ServerConfigBuilder props(Map<String, String> map) {
        this.configDataBuilder.props(map);
        return this;
    }

    @Override
    public ServerConfigBuilder sysProps() {
        this.configDataBuilder.sysProps();
        return this;
    }

    @Override
    public ServerConfigBuilder sysProps(String prefix) {
        this.configDataBuilder.sysProps(prefix);
        return this;
    }

    @Override
    public ServerConfigBuilder yaml(ByteSource byteSource) {
        this.configDataBuilder.yaml(byteSource);
        return this;
    }

    @Override
    public ServerConfigBuilder yaml(Path path) {
        this.configDataBuilder.yaml(path);
        return this;
    }

    @Override
    public ServerConfigBuilder yaml(URL url) {
        this.configDataBuilder.yaml(url);
        return this;
    }

    @Override
    public ServerConfigBuilder object(String path, Object object) {
        this.configDataBuilder.object(path, object);
        return this;
    }

    @Override
    public ServerConfigBuilder require(String pointer, TypeToken<?> type) {
        TypeToken<?> previous = this.required.put(Objects.requireNonNull(pointer, "pointer cannot be null"), Objects.requireNonNull(type, "type cannot be null"));
        if (previous != null) {
            throw new IllegalArgumentException("Cannot require config of type '" + type + "' at '" + pointer + "' as '" + previous + " has already been registered for this path");
        }
        return this;
    }

    @Override
    public ServerConfigBuilder onError(Action<? super Throwable> errorHandler) {
        this.configDataBuilder.onError(errorHandler);
        return this;
    }

    @Override
    public ServerConfigBuilder json(String path) {
        this.configDataBuilder.json(path);
        return this;
    }

    @Override
    public ServerConfigBuilder props(String path) {
        this.configDataBuilder.props(path);
        return this;
    }

    @Override
    public ServerConfigBuilder yaml(String path) {
        this.configDataBuilder.yaml(path);
        return this;
    }

    @Override
    public ImmutableList<ConfigSource> getConfigSources() {
        return this.configDataBuilder.getConfigSources();
    }

    @Override
    public ServerConfig build() {
        DefaultServerConfigBuilder copy = this.copy();
        this.impositions.get(ServerConfigImposition.class).ifPresent(c -> c.apply(copy));
        this.impositions.get(ForceServerListenPortImposition.class).map(ForceServerListenPortImposition::getPort).ifPresent(copy::port);
        this.impositions.get(ForceDevelopmentImposition.class).map(ForceDevelopmentImposition::isDevelopment).ifPresent(copy::development);
        copy.configDataBuilder.jacksonModules(new Module[]{new ConfigModule(copy.serverEnvironment, copy.baseDirSupplier)});
        DefaultConfigData configData = new DefaultConfigData(copy.configDataBuilder.getObjectMapper(), (Iterable<ConfigSource>)copy.getConfigSources(), (FileSystemBinding)MoreObjects.firstNonNull((Object)copy.baseDirSupplier.baseDir, (Object)FileSystemBinding.root()));
        ImmutableSet<ConfigObject<?>> requiredConfig = DefaultServerConfigBuilder.extractRequiredConfig(configData, copy.required);
        return new DefaultServerConfig(configData, requiredConfig);
    }

    private static ImmutableSet<ConfigObject<?>> extractRequiredConfig(ConfigData configData, Map<String, TypeToken<?>> required) {
        IllegalStateException badConfig = new IllegalStateException("Failed to build required config items");
        ImmutableSet.Builder config = ImmutableSet.builder();
        for (Map.Entry<String, TypeToken<?>> requiredConfig : required.entrySet()) {
            String path = requiredConfig.getKey();
            TypeToken<?> type = requiredConfig.getValue();
            try {
                config.add(configData.getAsConfigObject(path, type));
            }
            catch (Exception e) {
                badConfig.addSuppressed(new IllegalStateException("Could not bind config at '" + path + "' to '" + type + "'", e));
            }
        }
        if (badConfig.getSuppressed().length > 0) {
            throw badConfig;
        }
        return config.build();
    }

    private static class BaseDirSupplier
    implements Supplier<FileSystemBinding> {
        private FileSystemBinding baseDir;

        private BaseDirSupplier() {
        }

        @Override
        public FileSystemBinding get() {
            return this.baseDir;
        }
    }

    public static class ConfigModule
    extends SimpleModule {
        public ConfigModule(ServerEnvironment serverEnvironment, Supplier<FileSystemBinding> baseDirSupplier) {
            super("ratpack");
            this.addDeserializer(ServerConfigData.class, new ServerConfigDataDeserializer(serverEnvironment.getPort(), serverEnvironment.isDevelopment(), serverEnvironment.getPublicAddress(), baseDirSupplier));
            this.addDeserializer(SSLContext.class, new SSLContextDeserializer());
        }
    }
}

