/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.client.internal;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.pool.AbstractChannelPoolHandler;
import ratpack.http.client.internal.HttpChannelKey;
import ratpack.http.client.internal.IdlingConnectionHandler;
import ratpack.http.client.internal.InstrumentedChannelPoolHandler;

public class NoopFixedChannelPoolHandler
extends AbstractChannelPoolHandler
implements InstrumentedChannelPoolHandler {
    private final String host;

    public NoopFixedChannelPoolHandler(HttpChannelKey channelKey) {
        this.host = channelKey.host;
    }

    public void channelCreated(Channel ch) throws Exception {
    }

    public void channelReleased(Channel ch) throws Exception {
        if (ch.isOpen()) {
            ch.config().setAutoRead(true);
            ch.pipeline().addLast(new ChannelHandler[]{IdlingConnectionHandler.INSTANCE});
        }
    }

    public void channelAcquired(Channel ch) throws Exception {
        ch.pipeline().remove((ChannelHandler)IdlingConnectionHandler.INSTANCE);
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getActiveConnectionCount() {
        return 0;
    }

    @Override
    public int getIdleConnectionCount() {
        return 0;
    }
}

