/*
 * Decompiled with CFR 0.152.
 */
package ratpack.handling;

import com.google.common.reflect.TypeToken;
import ratpack.handling.internal.DefaultRequestId;
import ratpack.handling.internal.HeaderBasedRequestIdGenerator;
import ratpack.handling.internal.UuidBasedRequestIdGenerator;
import ratpack.http.Request;
import ratpack.util.Types;

public interface RequestId
extends CharSequence {
    public static final TypeToken<RequestId> TYPE = Types.token(RequestId.class);

    public static RequestId of(CharSequence requestId) {
        return new DefaultRequestId(requestId);
    }

    public static interface Generator {
        public static final TypeToken<Generator> TYPE = Types.token(Generator.class);

        public static Generator randomUuid() {
            return UuidBasedRequestIdGenerator.INSTANCE;
        }

        public static Generator header(CharSequence headerName) {
            return new HeaderBasedRequestIdGenerator(headerName, Generator.randomUuid());
        }

        public static Generator header(CharSequence headerName, Generator fallback) {
            return new HeaderBasedRequestIdGenerator(headerName, fallback);
        }

        public RequestId generate(Request var1);
    }
}

