/*
 * Decompiled with CFR 0.152.
 */
package ratpack.handling.internal;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javassist.ClassPool;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.NotFoundException;
import javassist.bytecode.ClassFile;
import ratpack.handling.Handler;

public class DescribingHandlers {
    public static void describeTo(Handler handler, StringBuilder stringBuilder) {
        Class<?> clazz = handler.getClass();
        if (clazz.isAnonymousClass()) {
            ClassPool pool = ClassPool.getDefault();
            try {
                CtClass ctClass = pool.get(clazz.getName());
                CtBehavior[] behaviors = ctClass.getDeclaredBehaviors();
                List withLineNumber = Arrays.asList(behaviors).stream().filter(input -> input.getMethodInfo().getLineNumber(0) > 0).sorted((o1, o2) -> Integer.valueOf(o1.getMethodInfo().getLineNumber(0)).compareTo(o2.getMethodInfo().getLineNumber(0))).collect(Collectors.toList());
                if (!withLineNumber.isEmpty()) {
                    CtBehavior method = (CtBehavior)withLineNumber.get(0);
                    int lineNumber = method.getMethodInfo().getLineNumber(0);
                    ClassFile classFile = ctClass.getClassFile();
                    String sourceFile = classFile.getSourceFile();
                    if (lineNumber != -1 && sourceFile != null) {
                        stringBuilder.append("anonymous class ").append(clazz.getName()).append(" at approximately line ").append(lineNumber).append(" of ").append(sourceFile);
                        return;
                    }
                }
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
        stringBuilder.append(clazz.getName());
    }
}

