/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.client.internal;

import java.util.Collection;
import java.util.Collections;
import ratpack.http.client.ProxySpec;
import ratpack.http.client.internal.ProxyInternal;

public class DefaultProxy
implements ProxyInternal {
    private final Spec spec;

    @Override
    public String getHost() {
        return this.spec.host;
    }

    @Override
    public int getPort() {
        return this.spec.port;
    }

    @Override
    public Collection<String> getNonProxyHosts() {
        return this.spec.nonProxyHosts;
    }

    @Override
    public boolean shouldProxy(String host) {
        return !this.isIgnoredForHost(host);
    }

    public boolean isIgnoredForHost(String hostname) {
        if (this.spec.nonProxyHosts != null && this.spec.nonProxyHosts.size() > 0) {
            for (String nonProxyHost : this.spec.nonProxyHosts) {
                if (!this.matchNonProxyHost(hostname, nonProxyHost)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matchNonProxyHost(String targetHost, String nonProxyHost) {
        if (nonProxyHost.length() > 1) {
            if (nonProxyHost.charAt(0) == '*') {
                return targetHost.regionMatches(true, targetHost.length() - nonProxyHost.length() + 1, nonProxyHost, 1, nonProxyHost.length() - 1);
            }
            if (nonProxyHost.charAt(nonProxyHost.length() - 1) == '*') {
                return targetHost.regionMatches(true, 0, nonProxyHost, 0, nonProxyHost.length() - 1);
            }
        }
        return nonProxyHost.equalsIgnoreCase(targetHost);
    }

    public DefaultProxy(Spec spec) {
        this.spec = spec;
    }

    public static class Spec
    implements ProxySpec {
        private String host;
        private int port;
        private Collection<String> nonProxyHosts = Collections.emptyList();

        @Override
        public ProxySpec host(String host) {
            this.host = host;
            return this;
        }

        @Override
        public ProxySpec port(int port) {
            this.port = port;
            return this;
        }

        @Override
        public ProxySpec nonProxyHosts(Collection<String> nonProxyHosts) {
            this.nonProxyHosts = nonProxyHosts;
            return this;
        }
    }
}

