/*
 * Decompiled with CFR 0.152.
 */
package ratpack.ssl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import ratpack.ssl.internal.SslContexts;

public class SSLContexts {
    public static SSLContext sslContext(URL keyStoreFile, String password) throws GeneralSecurityException, IOException {
        try (InputStream stream = keyStoreFile.openStream();){
            SSLContext sSLContext = SSLContexts.sslContext(stream, password);
            return sSLContext;
        }
    }

    public static SSLContext sslContext(URL keyStoreFile, String keyStorePassword, URL trustStoreFile, String trustStorePassword) throws GeneralSecurityException, IOException {
        try (InputStream keyStoreStream = keyStoreFile.openStream();){
            SSLContext sSLContext;
            block12: {
                InputStream trustStoreStream = trustStoreFile.openStream();
                try {
                    sSLContext = SSLContexts.sslContext(keyStoreStream, keyStorePassword, trustStoreStream, trustStorePassword);
                    if (trustStoreStream == null) break block12;
                }
                catch (Throwable throwable) {
                    if (trustStoreStream != null) {
                        try {
                            trustStoreStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                trustStoreStream.close();
            }
            return sSLContext;
        }
    }

    public static SSLContext sslContext(File keyStoreFile, String password) throws GeneralSecurityException, IOException {
        try (FileInputStream stream = new FileInputStream(keyStoreFile);){
            SSLContext sSLContext = SSLContexts.sslContext(stream, password);
            return sSLContext;
        }
    }

    public static SSLContext sslContext(File keyStoreFile, String keyStorePassword, File trustStoreFile, String trustStorePassword) throws GeneralSecurityException, IOException {
        try (FileInputStream keyStoreStream = new FileInputStream(keyStoreFile);){
            SSLContext sSLContext;
            try (FileInputStream trustStoreStream = new FileInputStream(trustStoreFile);){
                sSLContext = SSLContexts.sslContext((InputStream)keyStoreStream, keyStorePassword, (InputStream)trustStoreStream, trustStorePassword);
            }
            return sSLContext;
        }
    }

    public static SSLContext sslContext(Path keyStoreFile, String password) throws GeneralSecurityException, IOException {
        try (InputStream stream = Files.newInputStream(keyStoreFile, new OpenOption[0]);){
            SSLContext sSLContext = SSLContexts.sslContext(stream, password);
            return sSLContext;
        }
    }

    public static SSLContext sslContext(Path keyStoreFile, String keyStorePassword, Path trustStoreFile, String trustStorePassword) throws GeneralSecurityException, IOException {
        try (InputStream keyStoreStream = Files.newInputStream(keyStoreFile, new OpenOption[0]);){
            SSLContext sSLContext;
            block12: {
                InputStream trustStoreStream = Files.newInputStream(trustStoreFile, new OpenOption[0]);
                try {
                    sSLContext = SSLContexts.sslContext(keyStoreStream, keyStorePassword, trustStoreStream, trustStorePassword);
                    if (trustStoreStream == null) break block12;
                }
                catch (Throwable throwable) {
                    if (trustStoreStream != null) {
                        try {
                            trustStoreStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                trustStoreStream.close();
            }
            return sSLContext;
        }
    }

    public static SSLContext sslContext(InputStream keyStoreStream, String password) throws GeneralSecurityException, IOException {
        return SSLContexts.sslContext(keyStoreStream, password.toCharArray(), null, null);
    }

    public static SSLContext sslContext(InputStream keyStoreStream, String keyStorePassword, InputStream trustStoreStream, String trustStorePassword) throws GeneralSecurityException, IOException {
        return SSLContexts.sslContext(keyStoreStream, keyStorePassword.toCharArray(), trustStoreStream, trustStorePassword.toCharArray());
    }

    private static SSLContext sslContext(InputStream keyStoreStream, char[] keyStorePassword, InputStream trustStoreStream, char[] trustStorePassword) throws GeneralSecurityException, IOException {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        KeyManagerFactory keyManagerFactory = null;
        if (keyStoreStream != null) {
            keyManagerFactory = SslContexts.keyManagerFactory(keyStoreStream, keyStorePassword);
        }
        TrustManagerFactory trustManagerFactory = null;
        if (trustStoreStream != null) {
            trustManagerFactory = SslContexts.trustManagerFactory(trustStoreStream, trustStorePassword);
        }
        sslContext.init(keyManagerFactory != null ? keyManagerFactory.getKeyManagers() : null, trustManagerFactory != null ? trustManagerFactory.getTrustManagers() : null, null);
        return sslContext;
    }

    private SSLContexts() {
    }
}

