/*
 * Decompiled with CFR 0.152.
 */
package ratpack.config.internal.source;

import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.Properties;
import ratpack.config.internal.source.AbstractPropertiesConfigSource;
import ratpack.util.Exceptions;

public class ByteSourcePropertiesConfigSource
extends AbstractPropertiesConfigSource {
    private final ByteSource byteSource;

    public ByteSourcePropertiesConfigSource(Optional<String> prefix, ByteSource byteSource) {
        super(prefix);
        this.byteSource = byteSource;
    }

    @Override
    protected Properties loadProperties() throws Exception {
        Properties properties = new Properties();
        try (InputStream inputStream = this.byteSource.openStream();){
            properties.load(inputStream);
        }
        catch (IOException ex) {
            throw Exceptions.uncheck((Throwable)ex);
        }
        return properties;
    }
}

