/*
 * Decompiled with CFR 0.152.
 */
package ratpack.session.clientside.internal;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import ratpack.session.clientside.Crypto;
import ratpack.util.Exceptions;

public class DefaultCrypto
implements Crypto {
    private final SecretKeySpec secretKeySpec;
    private final String algorithm;
    private final boolean isInitializationVectorRequired;

    public DefaultCrypto(byte[] key, String algorithm) {
        String[] parts = algorithm.split("/");
        this.secretKeySpec = new SecretKeySpec(key, parts[0]);
        this.algorithm = algorithm;
        this.isInitializationVectorRequired = parts.length > 1 && !parts[1].equalsIgnoreCase("ECB");
    }

    @Override
    public byte[] encrypt(ByteBuf message) {
        return (byte[])Exceptions.uncheck(() -> {
            Cipher cipher = Cipher.getInstance(this.algorithm);
            cipher.init(1, this.secretKeySpec);
            ByteBuf messageBuf = Unpooled.wrappedBuffer((byte[])new byte[cipher.getOutputSize(message.readableBytes())]);
            cipher.update(message.nioBuffer(), messageBuf.nioBuffer());
            byte[] payload = cipher.doFinal();
            if (this.isInitializationVectorRequired) {
                byte[] ivBytes = cipher.getIV();
                messageBuf.release();
                int outputLength = 1 + ivBytes.length + payload.length;
                ByteBuf output = Unpooled.wrappedBuffer((byte[])new byte[outputLength]).resetWriterIndex().writeByte(ivBytes.length).writeBytes(ivBytes).writeBytes(payload);
                payload = output.array();
                output.release();
            }
            return payload;
        });
    }

    @Override
    public byte[] decrypt(ByteBuf message) {
        return (byte[])Exceptions.uncheck(() -> {
            Cipher cipher = Cipher.getInstance(this.algorithm);
            if (this.isInitializationVectorRequired) {
                byte ivByteLength = message.readByte();
                ByteBuf ivBytes = message.readBytes((int)ivByteLength);
                IvParameterSpec ivParameterSpec = new IvParameterSpec(ivBytes.array());
                ivBytes.release();
                cipher.init(2, (Key)this.secretKeySpec, ivParameterSpec);
            } else {
                cipher.init(2, this.secretKeySpec);
            }
            int messageLength = message.readableBytes();
            ByteBuf output = Unpooled.wrappedBuffer((byte[])new byte[cipher.getOutputSize(messageLength)]);
            cipher.update(message.readBytes(messageLength).nioBuffer(), output.nioBuffer());
            byte[] decrypted = cipher.doFinal();
            output.release();
            return decrypted;
        });
    }
}

