/*
 * Decompiled with CFR 0.152.
 */
package ratpack.session.internal;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import ratpack.session.SessionCookieConfig;
import ratpack.session.SessionIdGenerator;
import ratpack.session.SessionListener;
import ratpack.session.SessionManager;

public class DefaultSessionManager
implements SessionManager {
    private final SessionIdGenerator idGenerator;
    private final List<SessionListener> sessionListeners = new ArrayList<SessionListener>(1);
    private final SessionCookieConfig sessionCookieConfig;

    @Inject
    public DefaultSessionManager(SessionIdGenerator idGenerator, SessionCookieConfig sessionCookieConfig) {
        this.idGenerator = idGenerator;
        this.sessionCookieConfig = sessionCookieConfig;
    }

    @Override
    public String getCookieDomain() {
        return this.sessionCookieConfig.getDomain();
    }

    @Override
    public String getCookiePath() {
        return this.sessionCookieConfig.getPath();
    }

    @Override
    public int getCookieExpiryMins() {
        return this.sessionCookieConfig.getExpiresMins();
    }

    @Override
    public SessionIdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    @Override
    public void addSessionListener(SessionListener sessionListener) {
        this.sessionListeners.add(sessionListener);
    }

    @Override
    public void notifySessionInitiated(String sessionId) {
        for (SessionListener sessionListener : this.sessionListeners) {
            sessionListener.sessionInitiated(sessionId);
        }
    }

    @Override
    public void notifySessionTerminated(String sessionId) {
        for (SessionListener sessionListener : this.sessionListeners) {
            sessionListener.sessionTerminated(sessionId);
        }
    }
}

