/*
 * Decompiled with CFR 0.152.
 */
package ratpack.session.clientside;

import java.time.Duration;

public class ClientSideSessionConfig {
    private static final String LAST_ACCESS_TIME_TOKEN = "ratpack_lat";
    private String sessionCookieName = "ratpack_session";
    private String secretToken = Long.toString(System.currentTimeMillis() / 10000L);
    private String macAlgorithm = "HmacSHA1";
    private String secretKey;
    private String cipherAlgorithm = "AES/CBC/PKCS5Padding";
    private int maxSessionCookieSize = 1932;
    private Duration maxInactivityInterval = Duration.ofHours(24L);

    public String getSessionCookieName() {
        return this.sessionCookieName;
    }

    public void setSessionCookieName(String sessionCookieName) {
        this.sessionCookieName = sessionCookieName;
    }

    public String getLastAccessTimeCookieName() {
        return LAST_ACCESS_TIME_TOKEN;
    }

    public String getSecretToken() {
        return this.secretToken;
    }

    public void setSecretToken(String secretToken) {
        this.secretToken = secretToken;
    }

    public String getMacAlgorithm() {
        return this.macAlgorithm;
    }

    public void setMacAlgorithm(String macAlgorithm) {
        this.macAlgorithm = macAlgorithm;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getCipherAlgorithm() {
        return this.cipherAlgorithm;
    }

    public void setCipherAlgorithm(String cipherAlgorithm) {
        this.cipherAlgorithm = cipherAlgorithm;
    }

    public int getMaxSessionCookieSize() {
        return this.maxSessionCookieSize;
    }

    public void setMaxSessionCookieSize(int maxSessionCookieSize) {
        this.maxSessionCookieSize = maxSessionCookieSize < 1024 || maxSessionCookieSize > 4096 ? 2048 : maxSessionCookieSize;
    }

    public Duration getMaxInactivityInterval() {
        return this.maxInactivityInterval;
    }

    public void setMaxInactivityInterval(Duration maxInactivityInterval) {
        this.maxInactivityInterval = maxInactivityInterval;
    }
}

